/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.testplugin;

import com.netflix.spinnaker.kork.plugins.testplugin.TestPluginBuilderSupport;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="use testPlugin builder instead")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002&'B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001cH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$H\u0002J\b\u0010%\u001a\u00020\u001aH\u0002R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006("}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginBuilderSupport;", "", "pluginPath", "Ljava/nio/file/Path;", "packageName", "", "name", "version", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "canonicalExtensionClass", "getCanonicalExtensionClass", "()Ljava/lang/String;", "canonicalPluginClass", "getCanonicalPluginClass", "extensionConfigSrc", "extensionSrc", "getName", "getPackageName", "pluginId", "getPluginId", "getPluginPath", "()Ljava/nio/file/Path;", "pluginProperties", "pluginSrc", "getVersion", "build", "", "generateSources", "Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginBuilderSupport$GenerateResult;", "preparePluginDestination", "Ljava/io/File;", "setupCompiler", "Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginBuilderSupport$CompilerSetup;", "classesDir", "generated", "systemClasspath", "", "writePluginProperties", "CompilerSetup", "GenerateResult", "kork-plugins-tck"})
public final class TestPluginBuilderSupport {
    @NotNull
    private final Path pluginPath;
    @NotNull
    private final String packageName;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final String canonicalPluginClass;
    @NotNull
    private final String canonicalExtensionClass;
    @NotNull
    private final String pluginId;
    @NotNull
    private final String pluginSrc;
    @NotNull
    private final String extensionSrc;
    @NotNull
    private final String extensionConfigSrc;
    @NotNull
    private final String pluginProperties;

    public TestPluginBuilderSupport(@NotNull Path pluginPath, @NotNull String packageName, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.pluginPath = pluginPath;
        this.packageName = packageName;
        this.name = name;
        this.version = version;
        this.canonicalPluginClass = this.packageName + "." + this.name + "TestPlugin";
        this.canonicalExtensionClass = this.packageName + "." + this.name + "TestExtension";
        String string = this.name;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        this.pluginId = "spinnaker." + string3 + "testplugin";
        this.pluginSrc = StringsKt.trimIndent((String)("\n    package " + this.packageName + ";\n\n    import org.pf4j.Plugin;\n    import org.pf4j.PluginWrapper;\n\n    public class " + this.name + "TestPlugin extends Plugin {\n      public " + this.name + "TestPlugin(PluginWrapper wrapper) {\n        super(wrapper);\n      }\n    }\n    "));
        this.extensionSrc = StringsKt.trimIndent((String)("\n    package " + this.packageName + ";\n\n    import com.netflix.spinnaker.kork.plugins.testplugin.api.TestExtension;\n    import org.pf4j.Extension;\n\n    @Extension\n    public class " + this.name + "TestExtension implements TestExtension {\n\n      public " + this.name + "TestExtensionConfiguration config;\n\n      public " + this.name + "TestExtension(" + this.name + "TestExtensionConfiguration config) {\n        config = config;\n      }\n\n      @Override\n      public String getTestValue() {\n        return getClass().getSimpleName();\n      }\n    }\n    "));
        string = this.name;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        this.extensionConfigSrc = StringsKt.trimIndent((String)("\n    package " + this.packageName + ";\n\n    import com.netflix.spinnaker.kork.plugins.api.ExtensionConfiguration;\n\n    @ExtensionConfiguration(\"spinnaker." + string5 + "-test-extension\")\n    public class " + this.name + "TestExtensionConfiguration {\n      private String foo;\n    }\n    "));
        this.pluginProperties = StringsKt.trimIndent((String)("\n    plugin.id=" + this.pluginId + "\n    plugin.description=A generated TestPlugin named " + this.name + "\n    plugin.class=" + this.canonicalPluginClass + "\n    plugin.version=" + this.version + "\n    plugin.provider=Spinnaker\n    plugin.dependencies=\n    plugin.requires=*\n    plugin.license=Apache 2.0\n    plugin.unsafe=false\n    "));
    }

    public /* synthetic */ TestPluginBuilderSupport(Path path, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "com.netflix.spinnaker.kork.plugins.testplugin.generated";
        }
        if ((n & 4) != 0) {
            string2 = "Generated";
        }
        if ((n & 8) != 0) {
            string3 = "0.0.1";
        }
        this(path, string, string2, string3);
    }

    @NotNull
    public final Path getPluginPath() {
        return this.pluginPath;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getCanonicalPluginClass() {
        return this.canonicalPluginClass;
    }

    @NotNull
    public final String getCanonicalExtensionClass() {
        return this.canonicalExtensionClass;
    }

    @NotNull
    public final String getPluginId() {
        return this.pluginId;
    }

    public final void build() {
        GenerateResult generated = this.generateSources();
        File classesDir = this.preparePluginDestination();
        this.writePluginProperties();
        CompilerSetup compilerSetup = this.setupCompiler(classesDir, generated);
        if (!compilerSetup.getTask().call().booleanValue()) {
            Object object = compilerSetup.getDiagnostics().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue(object, (String)"compilerSetup.diagnostics.diagnostics");
            Iterable iterable = (Iterable)object;
            object = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lineSeparator()");
            String message2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)((CharSequence)object), null, null, (int)0, null, (Function1)build.message.1.INSTANCE, (int)30, null);
            throw new IllegalStateException("generation failed: " + System.lineSeparator() + message2);
        }
    }

    private final GenerateResult generateSources() {
        Path tempDir = Files.createTempDirectory("plugincodegen", new FileAttribute[0]);
        Path packageDir = tempDir.resolve(StringsKt.replace$default((String)this.packageName, (char)'.', (char)'/', (boolean)false, (int)4, null));
        packageDir.toFile().mkdirs();
        Path pluginFile = packageDir.resolve(this.name + "TestPlugin.java");
        File file = pluginFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"pluginFile.toFile()");
        FilesKt.writeText$default((File)file, (String)this.pluginSrc, null, (int)2, null);
        Path extensionFile = packageDir.resolve(this.name + "TestExtension.java");
        File file2 = extensionFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"extensionFile.toFile()");
        FilesKt.writeText$default((File)file2, (String)this.extensionSrc, null, (int)2, null);
        Path extensionConfigFile = packageDir.resolve(this.name + "TestExtensionConfiguration.java");
        File file3 = extensionConfigFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"extensionConfigFile.toFile()");
        FilesKt.writeText$default((File)file3, (String)this.extensionConfigSrc, null, (int)2, null);
        file3 = tempDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"tempDir.toFile()");
        TestPluginBuilderSupport.generateSources$cleanupTemp(file3);
        file3 = tempDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"tempDir.toFile()");
        File file4 = file3;
        file3 = pluginFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"pluginFile.toFile()");
        File file5 = file3;
        file3 = extensionFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"extensionFile.toFile()");
        File file6 = file3;
        file3 = extensionConfigFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"extensionConfigFile.toFile()");
        return new GenerateResult(file4, file5, file6, file3);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<File> systemClasspath() {
        void $this$mapTo$iv$iv;
        String[] stringArray = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getProperty(\"java.class.path\")");
        CharSequence charSequence = (CharSequence)stringArray;
        stringArray = new String[1];
        String string = System.getProperty("path.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"path.separator\")");
        stringArray[0] = string;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    private final File preparePluginDestination() {
        File file = this.pluginPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"pluginPath.toFile()");
        FilesKt.deleteRecursively((File)file);
        File classOutput = this.pluginPath.resolve("classes").toFile();
        classOutput.mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)classOutput, (String)"classOutput");
        return classOutput;
    }

    private final void writePluginProperties() {
        File file = this.pluginPath.resolve("plugin.properties").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"pluginPath.resolve(\"plugin.properties\").toFile()");
        FilesKt.writeText$default((File)file, (String)this.pluginProperties, null, (int)2, null);
    }

    private final CompilerSetup setupCompiler(File classesDir, GenerateResult generated) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector<JavaFileObject> diag = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager sfm = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diag, null, Charsets.UTF_8);
        sfm.setLocation(StandardLocation.CLASS_OUTPUT, CollectionsKt.listOf((Object)classesDir));
        sfm.setLocation(StandardLocation.SOURCE_PATH, CollectionsKt.listOf((Object)generated.getRootDir()));
        sfm.setLocation(StandardLocation.CLASS_PATH, this.systemClasspath());
        Object object = new File[]{generated.getPluginFile(), generated.getExtensionFile()};
        Iterable<? extends JavaFileObject> javaFiles = sfm.getJavaFileObjects((File)object);
        object = compiler.getTask(null, sfm, (DiagnosticListener<? super JavaFileObject>)diag, null, null, javaFiles);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compiler.getTask(null, s\u2026g, null, null, javaFiles)");
        return new CompilerSetup((JavaCompiler.CompilationTask)object, diag);
    }

    private static final void generateSources$cleanupTemp(File dir) {
        dir.deleteOnExit();
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                if (it.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    TestPluginBuilderSupport.generateSources$cleanupTemp(it);
                    continue;
                }
                it.deleteOnExit();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginBuilderSupport$GenerateResult;", "", "rootDir", "Ljava/io/File;", "pluginFile", "extensionFile", "extensionConfigFile", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getExtensionConfigFile", "()Ljava/io/File;", "getExtensionFile", "getPluginFile", "getRootDir", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kork-plugins-tck"})
    private static final class GenerateResult {
        @NotNull
        private final File rootDir;
        @NotNull
        private final File pluginFile;
        @NotNull
        private final File extensionFile;
        @NotNull
        private final File extensionConfigFile;

        public GenerateResult(@NotNull File rootDir, @NotNull File pluginFile, @NotNull File extensionFile, @NotNull File extensionConfigFile) {
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
            Intrinsics.checkNotNullParameter((Object)extensionFile, (String)"extensionFile");
            Intrinsics.checkNotNullParameter((Object)extensionConfigFile, (String)"extensionConfigFile");
            this.rootDir = rootDir;
            this.pluginFile = pluginFile;
            this.extensionFile = extensionFile;
            this.extensionConfigFile = extensionConfigFile;
        }

        @NotNull
        public final File getRootDir() {
            return this.rootDir;
        }

        @NotNull
        public final File getPluginFile() {
            return this.pluginFile;
        }

        @NotNull
        public final File getExtensionFile() {
            return this.extensionFile;
        }

        @NotNull
        public final File getExtensionConfigFile() {
            return this.extensionConfigFile;
        }

        @NotNull
        public final File component1() {
            return this.rootDir;
        }

        @NotNull
        public final File component2() {
            return this.pluginFile;
        }

        @NotNull
        public final File component3() {
            return this.extensionFile;
        }

        @NotNull
        public final File component4() {
            return this.extensionConfigFile;
        }

        @NotNull
        public final GenerateResult copy(@NotNull File rootDir, @NotNull File pluginFile, @NotNull File extensionFile, @NotNull File extensionConfigFile) {
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
            Intrinsics.checkNotNullParameter((Object)extensionFile, (String)"extensionFile");
            Intrinsics.checkNotNullParameter((Object)extensionConfigFile, (String)"extensionConfigFile");
            return new GenerateResult(rootDir, pluginFile, extensionFile, extensionConfigFile);
        }

        public static /* synthetic */ GenerateResult copy$default(GenerateResult generateResult, File file, File file2, File file3, File file4, int n, Object object) {
            if ((n & 1) != 0) {
                file = generateResult.rootDir;
            }
            if ((n & 2) != 0) {
                file2 = generateResult.pluginFile;
            }
            if ((n & 4) != 0) {
                file3 = generateResult.extensionFile;
            }
            if ((n & 8) != 0) {
                file4 = generateResult.extensionConfigFile;
            }
            return generateResult.copy(file, file2, file3, file4);
        }

        @NotNull
        public String toString() {
            return "GenerateResult(rootDir=" + this.rootDir + ", pluginFile=" + this.pluginFile + ", extensionFile=" + this.extensionFile + ", extensionConfigFile=" + this.extensionConfigFile + ")";
        }

        public int hashCode() {
            int result = this.rootDir.hashCode();
            result = result * 31 + this.pluginFile.hashCode();
            result = result * 31 + this.extensionFile.hashCode();
            result = result * 31 + this.extensionConfigFile.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GenerateResult)) {
                return false;
            }
            GenerateResult generateResult = (GenerateResult)other;
            if (!Intrinsics.areEqual((Object)this.rootDir, (Object)generateResult.rootDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pluginFile, (Object)generateResult.pluginFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extensionFile, (Object)generateResult.extensionFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extensionConfigFile, (Object)generateResult.extensionConfigFile);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginBuilderSupport$CompilerSetup;", "", "task", "Ljavax/tools/JavaCompiler$CompilationTask;", "diagnostics", "Ljavax/tools/DiagnosticCollector;", "Ljavax/tools/JavaFileObject;", "(Ljavax/tools/JavaCompiler$CompilationTask;Ljavax/tools/DiagnosticCollector;)V", "getDiagnostics", "()Ljavax/tools/DiagnosticCollector;", "getTask", "()Ljavax/tools/JavaCompiler$CompilationTask;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kork-plugins-tck"})
    private static final class CompilerSetup {
        @NotNull
        private final JavaCompiler.CompilationTask task;
        @NotNull
        private final DiagnosticCollector<JavaFileObject> diagnostics;

        public CompilerSetup(@NotNull JavaCompiler.CompilationTask task, @NotNull DiagnosticCollector<JavaFileObject> diagnostics) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            this.task = task;
            this.diagnostics = diagnostics;
        }

        @NotNull
        public final JavaCompiler.CompilationTask getTask() {
            return this.task;
        }

        @NotNull
        public final DiagnosticCollector<JavaFileObject> getDiagnostics() {
            return this.diagnostics;
        }

        @NotNull
        public final JavaCompiler.CompilationTask component1() {
            return this.task;
        }

        @NotNull
        public final DiagnosticCollector<JavaFileObject> component2() {
            return this.diagnostics;
        }

        @NotNull
        public final CompilerSetup copy(@NotNull JavaCompiler.CompilationTask task, @NotNull DiagnosticCollector<JavaFileObject> diagnostics) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            return new CompilerSetup(task, diagnostics);
        }

        public static /* synthetic */ CompilerSetup copy$default(CompilerSetup compilerSetup, JavaCompiler.CompilationTask compilationTask, DiagnosticCollector diagnosticCollector, int n, Object object) {
            if ((n & 1) != 0) {
                compilationTask = compilerSetup.task;
            }
            if ((n & 2) != 0) {
                diagnosticCollector = compilerSetup.diagnostics;
            }
            return compilerSetup.copy(compilationTask, diagnosticCollector);
        }

        @NotNull
        public String toString() {
            return "CompilerSetup(task=" + this.task + ", diagnostics=" + this.diagnostics + ")";
        }

        public int hashCode() {
            int result = this.task.hashCode();
            result = result * 31 + this.diagnostics.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilerSetup)) {
                return false;
            }
            CompilerSetup compilerSetup = (CompilerSetup)other;
            if (!Intrinsics.areEqual((Object)this.task, (Object)compilerSetup.task)) {
                return false;
            }
            return Intrinsics.areEqual(this.diagnostics, compilerSetup.diagnostics);
        }
    }
}

