/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.internal;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/kork/plugins/internal/PluginZip;", "", "builder", "Lcom/netflix/spinnaker/kork/plugins/internal/PluginZip$Builder;", "(Lcom/netflix/spinnaker/kork/plugins/internal/PluginZip$Builder;)V", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "pluginClass", "", "getPluginClass", "()Ljava/lang/String;", "pluginId", "getPluginId", "pluginVersion", "getPluginVersion", "unzippedPath", "Builder", "Companion", "kork-plugins-tck"})
public final class PluginZip {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final String pluginId;
    @NotNull
    private final String pluginClass;
    @NotNull
    private final String pluginVersion;

    private PluginZip(Builder builder) {
        this.path = builder.getPath();
        this.pluginId = builder.getPluginId();
        this.pluginClass = builder.getPluginClass();
        this.pluginVersion = builder.getPluginVersion();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public final String getPluginClass() {
        return this.pluginClass;
    }

    @NotNull
    public final String getPluginVersion() {
        return this.pluginVersion;
    }

    @NotNull
    public final Path unzippedPath() {
        String fileName = ((Object)this.path.getFileName()).toString();
        Path path = this.path.getParent();
        String string = fileName.substring(0, fileName.length() - 4);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Path path2 = path.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.parent.resolve(file\u2026 - ZIP_EXTENSION_LENGTH))");
        return path2;
    }

    public /* synthetic */ PluginZip(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0005J\u001a\u0010\u0015\u001a\u00020\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001cJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/kork/plugins/internal/PluginZip$Builder;", "", "path", "Ljava/nio/file/Path;", "pluginId", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "files", "", "", "getPath", "()Ljava/nio/file/Path;", "pluginClass", "getPluginClass", "()Ljava/lang/String;", "setPluginClass", "(Ljava/lang/String;)V", "getPluginId", "pluginVersion", "getPluginVersion", "setPluginVersion", "properties", "addFile", "content", "build", "Lcom/netflix/spinnaker/kork/plugins/internal/PluginZip;", "createPropertiesFile", "", "", "property", "name", "value", "kork-plugins-tck"})
    public static final class Builder {
        @NotNull
        private final Path path;
        @NotNull
        private final String pluginId;
        public String pluginClass;
        public String pluginVersion;
        @NotNull
        private final Map<String, String> properties;
        @NotNull
        private final Map<Path, byte[]> files;

        public Builder(@NotNull Path path, @NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            this.path = path;
            this.pluginId = pluginId;
            this.properties = new LinkedHashMap();
            this.files = new LinkedHashMap();
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final String getPluginId() {
            return this.pluginId;
        }

        @NotNull
        public final String getPluginClass() {
            String string = this.pluginClass;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginClass");
            return null;
        }

        public final void setPluginClass(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.pluginClass = string;
        }

        @NotNull
        public final String getPluginVersion() {
            String string = this.pluginVersion;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginVersion");
            return null;
        }

        public final void setPluginVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.pluginVersion = string;
        }

        @NotNull
        public final Builder pluginClass(@NotNull String pluginClass) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pluginClass, (String)"pluginClass");
            Builder $this$pluginClass_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$pluginClass_u24lambda_u2d0.setPluginClass(pluginClass);
            return builder;
        }

        @NotNull
        public final Builder pluginVersion(@NotNull String pluginVersion) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
            Builder $this$pluginVersion_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$pluginVersion_u24lambda_u2d1.setPluginVersion(pluginVersion);
            return builder;
        }

        @NotNull
        public final Builder properties(@NotNull Map<String, String> properties) {
            Builder builder;
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Builder $this$properties_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$properties_u24lambda_u2d2.properties.putAll(properties);
            return builder;
        }

        @NotNull
        public final Builder property(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$property_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$property_u24lambda_u2d3.properties.put(name, value);
            return builder;
        }

        @NotNull
        public final Builder addFile(@NotNull Path path, @NotNull byte[] content) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Builder $this$addFile_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$addFile_u24lambda_u2d4.files.put(path, (byte[])content.clone());
            return builder;
        }

        @NotNull
        public final Builder addFile(@NotNull Path path, @NotNull String content) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Builder $this$addFile_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            Map<Path, byte[]> map = $this$addFile_u24lambda_u2d5.files;
            byte[] byArray = content.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            map.put(path, byArray2);
            return builder;
        }

        @NotNull
        public final PluginZip build() {
            this.createPropertiesFile();
            return new PluginZip(this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void createPropertiesFile() {
            Map map = new LinkedHashMap();
            map.put("plugin.id", this.pluginId);
            map.put("plugin.version", this.getPluginVersion());
            map.put("plugin.class", this.getPluginClass());
            map.putAll(this.properties);
            Closeable closeable = new ZipOutputStream(new FileOutputStream(this.path.toFile()));
            Throwable throwable = null;
            try {
                ZipOutputStream outputStream = (ZipOutputStream)closeable;
                boolean bl = false;
                ZipEntry propertiesFile = new ZipEntry("plugin.properties");
                outputStream.putNextEntry(propertiesFile);
                Companion.createProperties(map).store(outputStream, "");
                outputStream.closeEntry();
                for (Map.Entry<Path, byte[]> fileEntry : this.files.entrySet()) {
                    ZipEntry file = new ZipEntry(((Object)fileEntry.getKey()).toString());
                    outputStream.putNextEntry(file);
                    outputStream.write(fileEntry.getValue());
                    outputStream.closeEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/netflix/spinnaker/kork/plugins/internal/PluginZip$Companion;", "", "()V", "createProperties", "Ljava/util/Properties;", "map", "", "", "kork-plugins-tck"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Properties createProperties(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Properties properties = new Properties();
            properties.putAll(map);
            return properties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

