/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.plugins.SpinnakerExtensionFactory;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager$sam$java_util_function_BooleanSupplier$0;
import com.netflix.spinnaker.kork.plugins.bundle.PluginBundleExtractor;
import com.netflix.spinnaker.kork.plugins.config.ConfigFactory;
import com.netflix.spinnaker.kork.plugins.finders.SpinnakerPluginDescriptorFinder;
import com.netflix.spinnaker.kork.plugins.loaders.PluginRefPluginLoader;
import com.netflix.spinnaker.kork.plugins.loaders.SpinnakerDefaultPluginLoader;
import com.netflix.spinnaker.kork.plugins.loaders.SpinnakerDevelopmentPluginLoader;
import com.netflix.spinnaker.kork.plugins.loaders.SpinnakerJarPluginLoader;
import com.netflix.spinnaker.kork.plugins.repository.PluginRefPluginRepository;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import com.netflix.spinnaker.kork.version.ServiceVersion;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.CompoundPluginLoader;
import org.pf4j.CompoundPluginRepository;
import org.pf4j.DefaultPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginFactory;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginRepository;
import org.pf4j.PluginStatusProvider;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0003789BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010#\u001a\u00020 H\u0014J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\u0007H\u0014J\b\u0010+\u001a\u00020\u0005H\u0014J\b\u0010,\u001a\u00020\u0014H\u0014J\b\u0010-\u001a\u00020\u000eH\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010\u000e2\b\u0010/\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010/\u001a\u00020\u0010H\u0014J\u001b\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020105H\u0000\u00a2\u0006\u0002\b6R#\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006:"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "Lorg/pf4j/DefaultPluginManager;", "serviceVersion", "Lcom/netflix/spinnaker/kork/version/ServiceVersion;", "spinnakerVersionManager", "Lorg/pf4j/VersionManager;", "statusProvider", "Lorg/pf4j/PluginStatusProvider;", "configFactory", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;", "sdkFactories", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/SdkFactory;", "serviceName", "", "pluginsRoot", "Ljava/nio/file/Path;", "pluginBundleExtractor", "Lcom/netflix/spinnaker/kork/plugins/bundle/PluginBundleExtractor;", "spinnakerPluginFactory", "Lorg/pf4j/PluginFactory;", "(Lcom/netflix/spinnaker/kork/version/ServiceVersion;Lorg/pf4j/VersionManager;Lorg/pf4j/PluginStatusProvider;Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;Ljava/util/List;Ljava/lang/String;Ljava/nio/file/Path;Lcom/netflix/spinnaker/kork/plugins/bundle/PluginBundleExtractor;Lorg/pf4j/PluginFactory;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getSpinnakerVersionManager", "()Lorg/pf4j/VersionManager;", "springExtensionFactory", "Lorg/pf4j/ExtensionFactory;", "getStatusProvider", "()Lorg/pf4j/PluginStatusProvider;", "createExtensionFactory", "createPluginDescriptorFinder", "Lorg/pf4j/PluginDescriptorFinder;", "createPluginLoader", "Lorg/pf4j/PluginLoader;", "createPluginRepository", "Lorg/pf4j/PluginRepository;", "createPluginStatusProvider", "createVersionManager", "getPluginFactory", "getSystemVersion", "loadPlugin", "pluginPath", "loadPluginFromPath", "Lorg/pf4j/PluginWrapper;", "setPlugins", "", "specifiedPlugins", "", "setPlugins$kork_plugins", "ExtensionFactoryDelegate", "PluginStatusProviderDelegate", "VersionManagerDelegate", "kork-plugins"})
@Beta
public class SpinnakerPluginManager
extends DefaultPluginManager {
    private final Lazy log$delegate;
    private final ExtensionFactory springExtensionFactory;
    private final ServiceVersion serviceVersion;
    @NotNull
    private final VersionManager spinnakerVersionManager;
    @NotNull
    private final PluginStatusProvider statusProvider;
    private final String serviceName;
    private final PluginBundleExtractor pluginBundleExtractor;
    private final PluginFactory spinnakerPluginFactory;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SpinnakerPluginManager spinnakerPluginManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getSystemVersion() {
        String string = this.serviceVersion.resolve();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)it, (Object)"unknown")) return "0.0.0";
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        CharSequence charSequence = string2;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            return "0.0.0";
        }
        boolean bl5 = false;
        if (bl5) {
            return "0.0.0";
        }
        String string3 = it;
        return string3;
    }

    @NotNull
    protected ExtensionFactory createExtensionFactory() {
        return new ExtensionFactoryDelegate();
    }

    @NotNull
    protected PluginStatusProvider createPluginStatusProvider() {
        return new PluginStatusProviderDelegate();
    }

    @NotNull
    protected VersionManager createVersionManager() {
        return new VersionManagerDelegate();
    }

    @NotNull
    protected PluginLoader createPluginLoader() {
        Function0 function0 = (Function0)new Function0<Boolean>(this){

            public final boolean invoke() {
                return ((SpinnakerPluginManager)((Object)this.receiver)).isDevelopment();
            }
        };
        SpinnakerPluginManager$sam$java_util_function_BooleanSupplier$0 spinnakerPluginManager$sam$java_util_function_BooleanSupplier$0 = new SpinnakerPluginManager$sam$java_util_function_BooleanSupplier$0(function0);
        function0 = (Function0)new Function0<Boolean>(this){

            public final boolean invoke() {
                return ((SpinnakerPluginManager)((Object)this.receiver)).isDevelopment();
            }
        };
        CompoundPluginLoader compoundPluginLoader = new CompoundPluginLoader().add((PluginLoader)new PluginRefPluginLoader((PluginManager)this), (BooleanSupplier)spinnakerPluginManager$sam$java_util_function_BooleanSupplier$0).add((PluginLoader)new SpinnakerDevelopmentPluginLoader((PluginManager)this), (BooleanSupplier)new SpinnakerPluginManager$sam$java_util_function_BooleanSupplier$0(function0)).add((PluginLoader)new SpinnakerDefaultPluginLoader((PluginManager)this)).add((PluginLoader)new SpinnakerJarPluginLoader((PluginManager)this));
        Intrinsics.checkNotNullExpressionValue((Object)compoundPluginLoader, (String)"CompoundPluginLoader()\n \u2026kerJarPluginLoader(this))");
        return (PluginLoader)compoundPluginLoader;
    }

    @NotNull
    protected PluginDescriptorFinder createPluginDescriptorFinder() {
        RuntimeMode runtimeMode = this.getRuntimeMode();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMode, (String)"this.getRuntimeMode()");
        return new SpinnakerPluginDescriptorFinder(runtimeMode, null, 2, null);
    }

    @Nullable
    protected PluginWrapper loadPluginFromPath(@NotNull Path pluginPath) {
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        Path path = this.pluginBundleExtractor.extractService(pluginPath, this.serviceName);
        if (path == null) {
            return null;
        }
        Path extractedPath = path;
        return super.loadPluginFromPath(extractedPath);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPlugins$kork_plugins(@NotNull Collection<? extends PluginWrapper> specifiedPlugins) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(specifiedPlugins, (String)"specifiedPlugins");
        Iterable iterable = specifiedPlugins;
        SpinnakerPluginManager spinnakerPluginManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PluginWrapper pluginWrapper = (PluginWrapper)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            String string = it.getPluginId();
            map.put(string, element$iv$iv);
        }
        spinnakerPluginManager.plugins = map = destination$iv$iv;
    }

    @NotNull
    protected PluginRepository createPluginRepository() {
        CompoundPluginRepository compoundPluginRepository = new CompoundPluginRepository();
        Path path = this.getPluginsRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginsRoot()");
        Function0 function0 = (Function0)new Function0<Boolean>(this){

            public final boolean invoke() {
                return ((SpinnakerPluginManager)((Object)this.receiver)).isDevelopment();
            }
        };
        CompoundPluginRepository compoundPluginRepository2 = compoundPluginRepository.add((PluginRepository)new PluginRefPluginRepository(path), (BooleanSupplier)new SpinnakerPluginManager$sam$java_util_function_BooleanSupplier$0(function0)).add(super.createPluginRepository());
        Intrinsics.checkNotNullExpressionValue((Object)compoundPluginRepository2, (String)"CompoundPluginRepository\u2026createPluginRepository())");
        return (PluginRepository)compoundPluginRepository2;
    }

    @NotNull
    protected PluginFactory getPluginFactory() {
        return this.spinnakerPluginFactory;
    }

    @Nullable
    public String loadPlugin(@Nullable Path pluginPath) {
        String string;
        boolean bl = pluginPath != null && !Files.notExists(pluginPath, new LinkOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Specified plugin '" + pluginPath + "' does not exist!";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.getLog().debug("Loading plugin from '{}'", (Object)pluginPath);
        PluginWrapper pluginWrapper = this.loadPluginFromPath(pluginPath);
        if (pluginWrapper != null) {
            PluginWrapper pluginWrapper2 = pluginWrapper;
            bl2 = false;
            bl3 = false;
            PluginWrapper it = pluginWrapper2;
            boolean bl5 = false;
            this.resolvePlugins();
            PluginDescriptor pluginDescriptor = it.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"it.descriptor");
            string = pluginDescriptor.getPluginId();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final VersionManager getSpinnakerVersionManager() {
        return this.spinnakerVersionManager;
    }

    @NotNull
    public final PluginStatusProvider getStatusProvider() {
        return this.statusProvider;
    }

    public SpinnakerPluginManager(@NotNull ServiceVersion serviceVersion, @NotNull VersionManager spinnakerVersionManager, @NotNull PluginStatusProvider statusProvider, @NotNull ConfigFactory configFactory, @NotNull List<? extends SdkFactory> sdkFactories, @NotNull String serviceName, @NotNull Path pluginsRoot, @NotNull PluginBundleExtractor pluginBundleExtractor, @NotNull PluginFactory spinnakerPluginFactory) {
        Intrinsics.checkNotNullParameter((Object)serviceVersion, (String)"serviceVersion");
        Intrinsics.checkNotNullParameter((Object)spinnakerVersionManager, (String)"spinnakerVersionManager");
        Intrinsics.checkNotNullParameter((Object)statusProvider, (String)"statusProvider");
        Intrinsics.checkNotNullParameter((Object)configFactory, (String)"configFactory");
        Intrinsics.checkNotNullParameter(sdkFactories, (String)"sdkFactories");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)pluginsRoot, (String)"pluginsRoot");
        Intrinsics.checkNotNullParameter((Object)pluginBundleExtractor, (String)"pluginBundleExtractor");
        Intrinsics.checkNotNullParameter((Object)spinnakerPluginFactory, (String)"spinnakerPluginFactory");
        super(pluginsRoot);
        this.serviceVersion = serviceVersion;
        this.spinnakerVersionManager = spinnakerVersionManager;
        this.statusProvider = statusProvider;
        this.serviceName = serviceName;
        this.pluginBundleExtractor = pluginBundleExtractor;
        this.spinnakerPluginFactory = spinnakerPluginFactory;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpinnakerPluginManager this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(((Object)((Object)this.this$0)).getClass());
            }
            {
                this.this$0 = spinnakerPluginManager;
                super(0);
            }
        }));
        this.springExtensionFactory = new SpinnakerExtensionFactory(this, configFactory, sdkFactories);
        this.systemVersion = this.getSystemVersion();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager$ExtensionFactoryDelegate;", "Lorg/pf4j/ExtensionFactory;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;)V", "create", "T", "extensionClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "kork-plugins"})
    private final class ExtensionFactoryDelegate
    implements ExtensionFactory {
        public <T> T create(@Nullable Class<T> extensionClass) {
            return (T)SpinnakerPluginManager.this.springExtensionFactory.create(extensionClass);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager$PluginStatusProviderDelegate;", "Lorg/pf4j/PluginStatusProvider;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;)V", "disablePlugin", "", "pluginId", "", "enablePlugin", "isPluginDisabled", "", "kork-plugins"})
    private final class PluginStatusProviderDelegate
    implements PluginStatusProvider {
        public void disablePlugin(@Nullable String pluginId) {
            SpinnakerPluginManager.this.getStatusProvider().disablePlugin(pluginId);
        }

        public boolean isPluginDisabled(@Nullable String pluginId) {
            return SpinnakerPluginManager.this.getStatusProvider().isPluginDisabled(pluginId);
        }

        public void enablePlugin(@Nullable String pluginId) {
            SpinnakerPluginManager.this.getStatusProvider().enablePlugin(pluginId);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager$VersionManagerDelegate;", "Lorg/pf4j/VersionManager;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;)V", "checkVersionConstraint", "", "version", "", "constraint", "compareVersions", "", "v1", "v2", "kork-plugins"})
    private final class VersionManagerDelegate
    implements VersionManager {
        public boolean checkVersionConstraint(@NotNull String version, @NotNull String constraint) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            return SpinnakerPluginManager.this.getSpinnakerVersionManager().checkVersionConstraint(version, constraint);
        }

        public int compareVersions(@NotNull String v1, @NotNull String v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return SpinnakerPluginManager.this.getSpinnakerVersionManager().compareVersions(v1, v2);
        }
    }
}

