/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.config.PluginsConfigurationProperties;
import com.netflix.spinnaker.kork.plugins.update.EnvironmentServerGroupLocationResolver;
import com.netflix.spinnaker.kork.plugins.update.EnvironmentServerGroupNameResolver;
import com.netflix.spinnaker.kork.plugins.update.downloader.FileDownloaderProvider;
import com.netflix.spinnaker.kork.plugins.update.downloader.Front50FileDownloader;
import com.netflix.spinnaker.kork.plugins.update.internal.Front50Service;
import com.netflix.spinnaker.kork.plugins.update.internal.PluginOkHttpClientProvider;
import com.netflix.spinnaker.kork.plugins.update.release.source.Front50PluginInfoReleaseSource;
import com.netflix.spinnaker.kork.plugins.update.release.source.PluginInfoReleaseSource;
import com.netflix.spinnaker.kork.plugins.update.repository.Front50UpdateRepository;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.pf4j.update.FileVerifier;
import org.pf4j.update.UpdateRepository;
import org.pf4j.update.verifier.CompoundVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@ConditionalOnProperty(value={"spinnaker.extensibility.repositories.front50.enabled"})
public class Front50PluginsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Front50PluginsConfiguration.class);

    @Bean
    public static PluginOkHttpClientProvider pluginsOkHttpClient(Environment environment) {
        OkHttpClientConfigurationProperties okHttpClientProperties = (OkHttpClientConfigurationProperties)Binder.get((Environment)environment).bind("ok-http-client", Bindable.of(OkHttpClientConfigurationProperties.class)).orElse((Object)new OkHttpClientConfigurationProperties());
        OkHttpClient okHttpClient = new OkHttp3ClientConfiguration(okHttpClientProperties).create().retryOnConnectionFailure(okHttpClientProperties.isRetryOnConnectionFailure()).build();
        return new PluginOkHttpClientProvider(okHttpClient);
    }

    @Bean
    public static Front50FileDownloader front50FileDownloader(Environment environment, PluginOkHttpClientProvider pluginsOkHttpClientProvider, Map<String, PluginsConfigurationProperties.PluginRepositoryProperties> pluginRepositoriesConfig) {
        PluginsConfigurationProperties.PluginRepositoryProperties front50RepositoryProps = pluginRepositoriesConfig.get("front50");
        URL front50Url = Front50PluginsConfiguration.getFront50Url(environment, front50RepositoryProps);
        return new Front50FileDownloader(pluginsOkHttpClientProvider.getOkHttpClient(), front50Url);
    }

    @Bean
    public static Front50Service pluginFront50Service(Environment environment, PluginOkHttpClientProvider pluginsOkHttpClientProvider, Map<String, PluginsConfigurationProperties.PluginRepositoryProperties> pluginRepositoriesConfig) {
        PluginsConfigurationProperties.PluginRepositoryProperties front50RepositoryProps = pluginRepositoriesConfig.get("front50");
        URL front50Url = Front50PluginsConfiguration.getFront50Url(environment, front50RepositoryProps);
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return (Front50Service)new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).baseUrl(front50Url).client(pluginsOkHttpClientProvider.getOkHttpClient()).build().create(Front50Service.class);
    }

    @Bean
    public static UpdateRepository pluginFront50UpdateRepository(Front50Service front50Service, Environment environment, Map<String, PluginsConfigurationProperties.PluginRepositoryProperties> pluginRepositoriesConfig, FileDownloaderProvider fileDownloaderProvider) {
        PluginsConfigurationProperties.PluginRepositoryProperties front50RepositoryProps = pluginRepositoriesConfig.get("front50");
        URL front50Url = Front50PluginsConfiguration.getFront50Url(environment, front50RepositoryProps);
        return new Front50UpdateRepository("front50", front50Url, fileDownloaderProvider.get(front50RepositoryProps.fileDownloader), (FileVerifier)new CompoundVerifier(), front50Service);
    }

    @Bean
    public static PluginInfoReleaseSource front50PluginReleaseProvider(Front50Service front50Service, Environment environment) {
        String appName = environment.getProperty("spring.application.name");
        Objects.requireNonNull(appName, "spring.application.name property must be set");
        EnvironmentServerGroupNameResolver nameResolver = new EnvironmentServerGroupNameResolver(environment);
        EnvironmentServerGroupLocationResolver locationResolver = new EnvironmentServerGroupLocationResolver(environment);
        return new Front50PluginInfoReleaseSource(front50Service, nameResolver, locationResolver, appName);
    }

    private static URL getFront50Url(Environment environment, PluginsConfigurationProperties.PluginRepositoryProperties front50RepositoryProps) {
        try {
            return front50RepositoryProps.getUrl();
        }
        catch (Exception e) {
            log.warn("Front50 update repository URL is either not specified or malformed, falling back to default configuration", (Throwable)e);
            return (URL)Binder.get((Environment)environment).bind("front50.base-url", Bindable.of(URL.class)).orElseGet(() -> (URL)Binder.get((Environment)environment).bind("services.front50.base-url", Bindable.of(URL.class)).get());
        }
    }
}

