/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/kork/plugins/CanonicalPluginId;", "", "namespace", "", "id", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getNamespace", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "MalformedPluginIdException", "kork-plugins"})
public final class CanonicalPluginId {
    @NotNull
    private final String namespace;
    @NotNull
    private final String id;
    private static final Pattern pattern;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public CanonicalPluginId(@NotNull String namespace, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.namespace = namespace;
        this.id = id;
    }

    static {
        Companion = new Companion(null);
        pattern = Pattern.compile("^(?<namespace>[\\w\\-.])+\\.(?<id>[\\w\\-]+)$");
    }

    @NotNull
    public final String component1() {
        return this.namespace;
    }

    @NotNull
    public final String component2() {
        return this.id;
    }

    @NotNull
    public final CanonicalPluginId copy(@NotNull String namespace, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new CanonicalPluginId(namespace, id);
    }

    public static /* synthetic */ CanonicalPluginId copy$default(CanonicalPluginId canonicalPluginId, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = canonicalPluginId.namespace;
        }
        if ((n & 2) != 0) {
            string2 = canonicalPluginId.id;
        }
        return canonicalPluginId.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "CanonicalPluginId(namespace=" + this.namespace + ", id=" + this.id + ")";
    }

    public int hashCode() {
        String string = this.namespace;
        String string2 = this.id;
        return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CanonicalPluginId)) break block3;
                CanonicalPluginId canonicalPluginId = (CanonicalPluginId)object;
                if (!Intrinsics.areEqual((Object)this.namespace, (Object)canonicalPluginId.namespace) || !Intrinsics.areEqual((Object)this.id, (Object)canonicalPluginId.id)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/kork/plugins/CanonicalPluginId$MalformedPluginIdException;", "Lcom/netflix/spinnaker/kork/exceptions/IntegrationException;", "providedId", "", "(Ljava/lang/String;)V", "kork-plugins"})
    public static final class MalformedPluginIdException
    extends IntegrationException {
        public MalformedPluginIdException(@NotNull String providedId) {
            Intrinsics.checkNotNullParameter((Object)providedId, (String)"providedId");
            super("Plugin '" + providedId + "' does not conform to Spinnaker's Canonical Plugin ID. " + "Canonical IDs must follow a '{namespace}.{pluginId}' format (" + pattern + ").");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/spinnaker/kork/plugins/CanonicalPluginId$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isValid", "", "pluginId", "", "parse", "Lcom/netflix/spinnaker/kork/plugins/CanonicalPluginId;", "validate", "", "kork-plugins"})
    public static final class Companion {
        public final boolean isValid(@NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            return pattern.matcher(pluginId).matches();
        }

        public final void validate(@NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            if (!this.isValid(pluginId)) {
                throw (Throwable)((Object)new MalformedPluginIdException(pluginId));
            }
        }

        @Nullable
        public final CanonicalPluginId parse(@NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Matcher matcher = pattern.matcher(pluginId);
            if (matcher.matches()) {
                String string = matcher.group("namespace");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"namespace\")");
                String string2 = matcher.group("id");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(\"id\")");
                return new CanonicalPluginId(string, string2);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

