/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClient;
import com.netflix.spinnaker.kork.plugins.api.httpclient.Request;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.Ok3HttpClient;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.Ok3Response;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0011\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\"\u001a\u00020#*\u00020\u0017H\u0002J\f\u0010$\u001a\u00020\u0015*\u00020%H\u0002R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClient;", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClient;", "name", "", "baseUrl", "client", "Lokhttp3/OkHttpClient;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getBaseUrl$kork_plugins", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getName$kork_plugins", "delete", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/Response;", "request", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/Request;", "doRequest", "builderCallback", "Lkotlin/Function1;", "Lokhttp3/Request$Builder;", "", "get", "patch", "post", "put", "requestBuilder", "okHttpRequestBody", "Lokhttp3/RequestBody;", "toGenericResponse", "Lokhttp3/Response;", "kork-plugins"})
public final class Ok3HttpClient
implements HttpClient {
    private final Lazy log$delegate;
    @NotNull
    private final String name;
    @NotNull
    private final String baseUrl;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Ok3HttpClient ok3HttpClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public com.netflix.spinnaker.kork.plugins.api.httpclient.Response get(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doRequest(request, (Function1<? super Request.Builder, Unit>)((Function1)get.1.INSTANCE));
    }

    @NotNull
    public com.netflix.spinnaker.kork.plugins.api.httpclient.Response post(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doRequest(request, (Function1<? super Request.Builder, Unit>)((Function1)new Function1<Request.Builder, Unit>(this, request){
            final /* synthetic */ Ok3HttpClient this$0;
            final /* synthetic */ Request $request;

            public final void invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.post(Ok3HttpClient.access$okHttpRequestBody(this.this$0, this.$request));
            }
            {
                this.this$0 = ok3HttpClient;
                this.$request = request;
                super(1);
            }
        }));
    }

    @NotNull
    public com.netflix.spinnaker.kork.plugins.api.httpclient.Response put(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doRequest(request, (Function1<? super Request.Builder, Unit>)((Function1)new Function1<Request.Builder, Unit>(this, request){
            final /* synthetic */ Ok3HttpClient this$0;
            final /* synthetic */ Request $request;

            public final void invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.put(Ok3HttpClient.access$okHttpRequestBody(this.this$0, this.$request));
            }
            {
                this.this$0 = ok3HttpClient;
                this.$request = request;
                super(1);
            }
        }));
    }

    @NotNull
    public com.netflix.spinnaker.kork.plugins.api.httpclient.Response delete(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doRequest(request, (Function1<? super Request.Builder, Unit>)((Function1)new Function1<Request.Builder, Unit>(this, request){
            final /* synthetic */ Ok3HttpClient this$0;
            final /* synthetic */ Request $request;

            public final void invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$request.getBody() == null) {
                    it.delete();
                } else {
                    it.delete(Ok3HttpClient.access$okHttpRequestBody(this.this$0, this.$request));
                }
            }
            {
                this.this$0 = ok3HttpClient;
                this.$request = request;
                super(1);
            }
        }));
    }

    @NotNull
    public com.netflix.spinnaker.kork.plugins.api.httpclient.Response patch(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.doRequest(request, (Function1<? super Request.Builder, Unit>)((Function1)new Function1<Request.Builder, Unit>(this, request){
            final /* synthetic */ Ok3HttpClient this$0;
            final /* synthetic */ Request $request;

            public final void invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.patch(Ok3HttpClient.access$okHttpRequestBody(this.this$0, this.$request));
            }
            {
                this.this$0 = ok3HttpClient;
                this.$request = request;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final com.netflix.spinnaker.kork.plugins.api.httpclient.Response doRequest(Request request, Function1<? super Request.Builder, Unit> builderCallback) {
        Object object = this.requestBuilder(request);
        boolean bl = false;
        boolean bl2 = false;
        builderCallback.invoke(object);
        okhttp3.Request okRequest = object.build();
        try {
            com.netflix.spinnaker.kork.plugins.api.httpclient.Response response2;
            object = (Closeable)this.client.newCall(okRequest).execute();
            bl = false;
            bl2 = false;
            Throwable throwable = null;
            try {
                Response it = (Response)object;
                boolean bl3 = false;
                Response response3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"it");
                response2 = this.toGenericResponse(response3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = response2;
        }
        catch (IOException io) {
            this.getLog().error(okRequest.tag() + " request failed", (Throwable)io);
            object = new Ok3Response(this.objectMapper, null, io);
        }
        return object;
    }

    private final Request.Builder requestBuilder(Request request) {
        String url = StringsKt.replace$default((String)(this.baseUrl + request.getPath()), (String)"//", (String)"/", (boolean)false, (int)4, null);
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null || (httpUrl = httpUrl.newBuilder()) == null) {
            throw (Throwable)new IntegrationException("Unable to parse url '" + this.baseUrl + '\'');
        }
        HttpUrl httpUrlBuilder = httpUrl;
        Map map = request.getQueryParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"request.queryParams");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            httpUrlBuilder.addQueryParameter((String)it.getKey(), (String)it.getValue());
        }
        Request.Builder builder = new Request.Builder().tag((Object)(this.name + '.' + request.getName())).url(httpUrlBuilder.build()).headers(Headers.of((Map)request.getHeaders()));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"okhttp3.Request.Builder(\u2026ders.of(request.headers))");
        return builder;
    }

    private final RequestBody okHttpRequestBody(Request $this$okHttpRequestBody) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)$this$okHttpRequestBody.getContentType()), (String)this.objectMapper.writeValueAsString($this$okHttpRequestBody.getBody()));
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"RequestBody.create(Media\u2026writeValueAsString(body))");
        return requestBody;
    }

    private final com.netflix.spinnaker.kork.plugins.api.httpclient.Response toGenericResponse(Response $this$toGenericResponse) {
        return new Ok3Response(this.objectMapper, $this$toGenericResponse, null);
    }

    @NotNull
    public final String getName$kork_plugins() {
        return this.name;
    }

    @NotNull
    public final String getBaseUrl$kork_plugins() {
        return this.baseUrl;
    }

    public Ok3HttpClient(@NotNull String name, @NotNull String baseUrl, @NotNull OkHttpClient client, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.name = name;
        this.baseUrl = baseUrl;
        this.client = client;
        this.objectMapper = objectMapper;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Ok3HttpClient this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = ok3HttpClient;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ RequestBody access$okHttpRequestBody(Ok3HttpClient $this, Request $this$access_u24okHttpRequestBody) {
        return $this.okHttpRequestBody($this$access_u24okHttpRequestBody);
    }
}

