/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientConfig;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.OkHttp3ClientFactory;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal.DefaultOkHttp3ClientFactory$WhenMappings;
import com.netflix.spinnaker.okhttp.OkHttp3MetricsInterceptor;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/internal/DefaultOkHttp3ClientFactory;", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;", "okHttpClientHttp3MetricsInterceptor", "Lcom/netflix/spinnaker/okhttp/OkHttp3MetricsInterceptor;", "(Lcom/netflix/spinnaker/okhttp/OkHttp3MetricsInterceptor;)V", "convertToOkHttp", "Lcom/netflix/spinnaker/okhttp/OkHttpClientConfigurationProperties;", "config", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientConfig;", "create", "Lokhttp3/OkHttpClient;", "baseUrl", "", "supports", "", "kork-plugins"})
public final class DefaultOkHttp3ClientFactory
implements OkHttp3ClientFactory {
    private final OkHttp3MetricsInterceptor okHttpClientHttp3MetricsInterceptor;

    @Override
    public boolean supports(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return StringsKt.startsWith$default((String)baseUrl, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)baseUrl, (String)"https://", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public OkHttpClient create(@NotNull String baseUrl, @NotNull HttpClientConfig config) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            var3_3 = new OkHttp3ClientConfiguration(this.convertToOkHttp(config), this.okHttpClientHttp3MetricsInterceptor).create();
            var4_4 = false;
            var5_5 = false;
            it = var3_3;
            $i$a$-also-DefaultOkHttp3ClientFactory$create$1 = false;
            v0 = config.getLogging();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"config.logging");
            if (v0.getLevel() == HttpClientConfig.LoggingConfig.LoggingLevel.NONE) break block5;
            var8_8 = new HttpLoggingInterceptor(null, 1, null);
            var9_9 = false;
            var10_10 = false;
            var11_11 = var8_8;
            var12_12 = it;
            $i$a$-apply-DefaultOkHttp3ClientFactory$create$1$1 = false;
            v1 = config.getLogging();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"config.logging");
            v2 = v1.getLevel();
            if (v2 == null) ** GOTO lbl-1000
            switch (DefaultOkHttp3ClientFactory$WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                case 1: {
                    v3 = HttpLoggingInterceptor.Level.BASIC;
                    break;
                }
                case 2: {
                    v3 = HttpLoggingInterceptor.Level.HEADERS;
                    break;
                }
                case 3: {
                    v3 = HttpLoggingInterceptor.Level.BODY;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v4 = new StringBuilder().append("Unsupported logging level: ");
                    v5 = config.getLogging();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"config.logging");
                    throw (Throwable)new SystemException(v4.append(v5.getLevel()).toString());
                }
            }
            $this$apply.level(v3);
            var14_14 = Unit.INSTANCE;
            var12_12.addInterceptor((Interceptor)var8_8);
        }
        return var3_3.build();
    }

    private final OkHttpClientConfigurationProperties convertToOkHttp(HttpClientConfig config) {
        boolean bl;
        boolean bl2;
        Comparable<Duration> comparable;
        OkHttpClientConfigurationProperties okHttpClientConfigurationProperties = new OkHttpClientConfigurationProperties();
        boolean bl3 = false;
        boolean bl4 = false;
        OkHttpClientConfigurationProperties $this$apply = okHttpClientConfigurationProperties;
        boolean bl5 = false;
        HttpClientConfig.ConnectionPoolConfig connectionPoolConfig = config.getConnectionPool();
        Intrinsics.checkNotNullExpressionValue((Object)connectionPoolConfig, (String)"config.connectionPool");
        Duration duration = connectionPoolConfig.getKeepAlive();
        if (duration != null) {
            comparable = duration;
            bl2 = false;
            bl = false;
            Duration it = comparable;
            boolean bl6 = false;
            OkHttpClientConfigurationProperties.ConnectionPoolProperties connectionPoolProperties = $this$apply.getConnectionPool();
            Intrinsics.checkNotNullExpressionValue((Object)connectionPoolProperties, (String)"connectionPool");
            connectionPoolProperties.setKeepAliveDurationMs((int)it.toMillis());
        }
        HttpClientConfig.ConnectionPoolConfig connectionPoolConfig2 = config.getConnectionPool();
        Intrinsics.checkNotNullExpressionValue((Object)connectionPoolConfig2, (String)"config.connectionPool");
        Integer n = connectionPoolConfig2.getMaxIdleConnections();
        if (n != null) {
            comparable = n;
            bl2 = false;
            bl = false;
            int it = ((Number)((Object)comparable)).intValue();
            boolean bl7 = false;
            OkHttpClientConfigurationProperties.ConnectionPoolProperties connectionPoolProperties = $this$apply.getConnectionPool();
            Intrinsics.checkNotNullExpressionValue((Object)connectionPoolProperties, (String)"connectionPool");
            connectionPoolProperties.setMaxIdleConnections(it);
        }
        HttpClientConfig.ConnectionConfig connectionConfig = config.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connectionConfig, (String)"config.connection");
        Duration duration2 = connectionConfig.getConnectTimeout();
        if (duration2 != null) {
            comparable = duration2;
            bl2 = false;
            bl = false;
            Comparable<Duration> it = comparable;
            boolean bl8 = false;
            $this$apply.setConnectTimeoutMs(((Duration)it).toMillis());
        }
        HttpClientConfig.ConnectionConfig connectionConfig2 = config.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connectionConfig2, (String)"config.connection");
        Duration duration3 = connectionConfig2.getReadTimeout();
        if (duration3 != null) {
            comparable = duration3;
            bl2 = false;
            bl = false;
            Comparable<Duration> it = comparable;
            boolean bl9 = false;
            $this$apply.setReadTimeoutMs(((Duration)it).toMillis());
        }
        HttpClientConfig.ConnectionConfig connectionConfig3 = config.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connectionConfig3, (String)"config.connection");
        $this$apply.setRetryOnConnectionFailure(connectionConfig3.isRetryOnConnectionFailure());
        HttpClientConfig.SecurityConfig securityConfig = config.getSecurity();
        Intrinsics.checkNotNullExpressionValue((Object)securityConfig, (String)"config.security");
        if (securityConfig.getKeyStorePath() != null) {
            HttpClientConfig.SecurityConfig securityConfig2 = config.getSecurity();
            Intrinsics.checkNotNullExpressionValue((Object)securityConfig2, (String)"config.security");
            if (securityConfig2.getTrustStorePath() != null) {
                HttpClientConfig.SecurityConfig securityConfig3 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig3, (String)"config.security");
                $this$apply.setKeyStore(securityConfig3.getKeyStorePath().toFile());
                HttpClientConfig.SecurityConfig securityConfig4 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig4, (String)"config.security");
                $this$apply.setKeyStoreType(securityConfig4.getKeyStoreType());
                HttpClientConfig.SecurityConfig securityConfig5 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig5, (String)"config.security");
                $this$apply.setKeyStorePassword(securityConfig5.getKeyStorePassword());
                HttpClientConfig.SecurityConfig securityConfig6 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig6, (String)"config.security");
                $this$apply.setTrustStore(securityConfig6.getTrustStorePath().toFile());
                HttpClientConfig.SecurityConfig securityConfig7 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig7, (String)"config.security");
                $this$apply.setTrustStoreType(securityConfig7.getTrustStoreType());
                HttpClientConfig.SecurityConfig securityConfig8 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig8, (String)"config.security");
                $this$apply.setTrustStorePassword(securityConfig8.getTrustStorePassword());
                HttpClientConfig.SecurityConfig securityConfig9 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig9, (String)"config.security");
                $this$apply.setTlsVersions(securityConfig9.getTlsVersions());
                HttpClientConfig.SecurityConfig securityConfig10 = config.getSecurity();
                Intrinsics.checkNotNullExpressionValue((Object)securityConfig10, (String)"config.security");
                $this$apply.setCipherSuites(securityConfig10.getCipherSuites());
            }
        }
        return okHttpClientConfigurationProperties;
    }

    public DefaultOkHttp3ClientFactory(@NotNull OkHttp3MetricsInterceptor okHttpClientHttp3MetricsInterceptor) {
        Intrinsics.checkNotNullParameter((Object)okHttpClientHttp3MetricsInterceptor, (String)"okHttpClientHttp3MetricsInterceptor");
        this.okHttpClientHttp3MetricsInterceptor = okHttpClientHttp3MetricsInterceptor;
    }

    @Override
    @NotNull
    public String normalizeBaseUrl(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return OkHttp3ClientFactory.DefaultImpls.normalizeBaseUrl(this, baseUrl);
    }
}

