/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.remote.extension.transport.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.api.plugins.remote.RemoteExtensionConfig;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionPayload;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionQuery;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionResponse;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionTransport;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.http.OkHttpRemoteExtensionTransportException;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/http/OkHttpRemoteExtensionTransport;", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionTransport;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "client", "Lokhttp3/OkHttpClient;", "httpConfig", "Lcom/netflix/spinnaker/kork/api/plugins/remote/RemoteExtensionConfig$RemoteExtensionTransportConfig$Http;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lokhttp3/OkHttpClient;Lcom/netflix/spinnaker/kork/api/plugins/remote/RemoteExtensionConfig$RemoteExtensionTransportConfig$Http;)V", "url", "Lokhttp3/HttpUrl;", "buildHeaders", "Lokhttp3/Headers;", "headers", "", "", "buildUrl", "additionalParams", "invoke", "", "remoteExtensionPayload", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionPayload;", "read", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionResponse;", "remoteExtensionQuery", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionQuery;", "write", "toParams", "kork-plugins"})
public final class OkHttpRemoteExtensionTransport
implements RemoteExtensionTransport {
    private final HttpUrl url;
    private final ObjectMapper objectMapper;
    private final OkHttpClient client;
    private final RemoteExtensionConfig.RemoteExtensionTransportConfig.Http httpConfig;

    @Override
    public void invoke(@NotNull RemoteExtensionPayload remoteExtensionPayload) {
        Intrinsics.checkNotNullParameter((Object)remoteExtensionPayload, (String)"remoteExtensionPayload");
        AuthenticatedRequest.propagate((Callable)new Callable<Unit>(this, remoteExtensionPayload){
            final /* synthetic */ OkHttpRemoteExtensionTransport this$0;
            final /* synthetic */ RemoteExtensionPayload $remoteExtensionPayload;

            public final void call() {
                Request.Builder builder = new Request.Builder().url(OkHttpRemoteExtensionTransport.access$getUrl$p(this.this$0));
                RemoteExtensionConfig.RemoteExtensionTransportConfig.Http.Headers headers = OkHttpRemoteExtensionTransport.access$getHttpConfig$p(this.this$0).getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"httpConfig.headers");
                Map map = headers.getInvokeHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"httpConfig.headers.invokeHeaders");
                Request.Builder builder2 = builder.headers(OkHttpRemoteExtensionTransport.access$buildHeaders(this.this$0, map));
                String string = OkHttpRemoteExtensionTransport.access$getObjectMapper$p(this.this$0).writeValueAsString((Object)this.$remoteExtensionPayload);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueA\u2026g(remoteExtensionPayload)");
                Request request = builder2.post(RequestBody.Companion.create(string, MediaType.Companion.get("application/json"))).build();
                Response response2 = OkHttpRemoteExtensionTransport.access$getClient$p(this.this$0).newCall(request).execute();
                if (!response2.isSuccessful()) {
                    Object object = response2.body();
                    if (object == null || (object = object.string()) == null) {
                        object = "Unknown reason: " + response2.code();
                    }
                    Object reason = object;
                    throw (Throwable)((Object)new OkHttpRemoteExtensionTransportException((String)reason));
                }
            }
            {
                this.this$0 = okHttpRemoteExtensionTransport;
                this.$remoteExtensionPayload = remoteExtensionPayload;
            }
        }).call();
    }

    @Override
    @NotNull
    public RemoteExtensionResponse write(@NotNull RemoteExtensionPayload remoteExtensionPayload) {
        Intrinsics.checkNotNullParameter((Object)remoteExtensionPayload, (String)"remoteExtensionPayload");
        Object v = AuthenticatedRequest.propagate((Callable)new Callable<RemoteExtensionResponse>(this, remoteExtensionPayload){
            final /* synthetic */ OkHttpRemoteExtensionTransport this$0;
            final /* synthetic */ RemoteExtensionPayload $remoteExtensionPayload;

            public final RemoteExtensionResponse call() {
                Request.Builder builder = new Request.Builder().url(OkHttpRemoteExtensionTransport.access$getUrl$p(this.this$0));
                RemoteExtensionConfig.RemoteExtensionTransportConfig.Http.Headers headers = OkHttpRemoteExtensionTransport.access$getHttpConfig$p(this.this$0).getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"httpConfig.headers");
                Map map = headers.getWriteHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"httpConfig.headers.writeHeaders");
                Request.Builder builder2 = builder.headers(OkHttpRemoteExtensionTransport.access$buildHeaders(this.this$0, map));
                String string = OkHttpRemoteExtensionTransport.access$getObjectMapper$p(this.this$0).writeValueAsString((Object)this.$remoteExtensionPayload);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueA\u2026g(remoteExtensionPayload)");
                Request request = builder2.post(RequestBody.Companion.create(string, MediaType.Companion.get("application/json"))).build();
                Response response2 = OkHttpRemoteExtensionTransport.access$getClient$p(this.this$0).newCall(request).execute();
                if (!response2.isSuccessful()) {
                    Object object = response2.body();
                    if (object == null || (object = object.string()) == null) {
                        object = "Unknown reason: " + response2.code();
                    }
                    Object reason = object;
                    throw (Throwable)((Object)new OkHttpRemoteExtensionTransportException((String)reason));
                }
                ResponseBody responseBody = response2.body();
                return (RemoteExtensionResponse)OkHttpRemoteExtensionTransport.access$getObjectMapper$p(this.this$0).readValue(responseBody != null ? responseBody.string() : null, RemoteExtensionResponse.class);
            }
            {
                this.this$0 = okHttpRemoteExtensionTransport;
                this.$remoteExtensionPayload = remoteExtensionPayload;
            }
        }).call();
        Intrinsics.checkNotNullExpressionValue(v, (String)"AuthenticatedRequest.pro\u2026:class.java)\n    }.call()");
        return (RemoteExtensionResponse)v;
    }

    @Override
    @NotNull
    public RemoteExtensionResponse read(@NotNull RemoteExtensionQuery remoteExtensionQuery) {
        Intrinsics.checkNotNullParameter((Object)remoteExtensionQuery, (String)"remoteExtensionQuery");
        Object v = AuthenticatedRequest.propagate((Callable)new Callable<RemoteExtensionResponse>(this, remoteExtensionQuery){
            final /* synthetic */ OkHttpRemoteExtensionTransport this$0;
            final /* synthetic */ RemoteExtensionQuery $remoteExtensionQuery;

            public final RemoteExtensionResponse call() {
                Request.Builder builder = new Request.Builder().url(OkHttpRemoteExtensionTransport.access$buildUrl(this.this$0, OkHttpRemoteExtensionTransport.access$toParams(this.this$0, this.$remoteExtensionQuery)));
                RemoteExtensionConfig.RemoteExtensionTransportConfig.Http.Headers headers = OkHttpRemoteExtensionTransport.access$getHttpConfig$p(this.this$0).getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"httpConfig.headers");
                Map map = headers.getReadHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"httpConfig.headers.readHeaders");
                Request request = builder.headers(OkHttpRemoteExtensionTransport.access$buildHeaders(this.this$0, map)).get().build();
                Response response2 = OkHttpRemoteExtensionTransport.access$getClient$p(this.this$0).newCall(request).execute();
                if (!response2.isSuccessful()) {
                    Object object = response2.body();
                    if (object == null || (object = object.string()) == null) {
                        object = "Unknown reason: " + response2.code();
                    }
                    Object reason = object;
                    throw (Throwable)((Object)new OkHttpRemoteExtensionTransportException((String)reason));
                }
                ResponseBody responseBody = response2.body();
                return (RemoteExtensionResponse)OkHttpRemoteExtensionTransport.access$getObjectMapper$p(this.this$0).readValue(responseBody != null ? responseBody.string() : null, RemoteExtensionResponse.class);
            }
            {
                this.this$0 = okHttpRemoteExtensionTransport;
                this.$remoteExtensionQuery = remoteExtensionQuery;
            }
        }).call();
        Intrinsics.checkNotNullExpressionValue(v, (String)"AuthenticatedRequest.pro\u2026:class.java)\n    }.call()");
        return (RemoteExtensionResponse)v;
    }

    private final HttpUrl buildUrl(Map<String, String> additionalParams) {
        String string = this.httpConfig.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpConfig.url");
        HttpUrl httpUrl = HttpUrl.Companion.parse(string);
        if (httpUrl == null || (httpUrl = httpUrl.newBuilder()) == null) {
            throw (Throwable)new IntegrationException("Unable to parse url '" + this.httpConfig.getUrl() + '\'');
        }
        HttpUrl httpUrlBuilder = httpUrl;
        Map map = this.httpConfig.getQueryParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"httpConfig.queryParams");
        Map $this$forEach$iv = MapsKt.plus((Map)map, additionalParams);
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            httpUrlBuilder.addQueryParameter((String)k, (String)it.getValue());
        }
        return httpUrlBuilder.build();
    }

    private final Headers buildHeaders(Map<String, String> headers) {
        String key;
        Object value;
        boolean bl;
        Map.Entry entry;
        Map.Entry $dstr$key$value;
        Map.Entry<Object, Object> element$iv;
        Headers.Builder headersBuilder = new Headers.Builder();
        Map<String, String> map = AuthenticatedRequest.getAuthenticationHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"AuthenticatedRequest.getAuthenticationHeaders()");
        Map<String, String> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map<String, String> map2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<Object, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$key$value = element$iv = iterator.next();
            boolean bl3 = false;
            entry = $dstr$key$value;
            bl = false;
            String string = (String)entry.getKey();
            entry = $dstr$key$value;
            bl = false;
            value = (Optional)entry.getValue();
            Optional optional = value;
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"value");
            if (!optional.isPresent()) continue;
            String string2 = key.toString();
            Object t = ((Optional)value).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"value.get()");
            headersBuilder.add(string2, (String)t);
        }
        $this$forEach$iv = headers;
        $i$f$forEach = false;
        map2 = $this$forEach$iv;
        bl2 = false;
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$key$value = element$iv = iterator.next();
            boolean bl4 = false;
            entry = $dstr$key$value;
            bl = false;
            key = (String)entry.getKey();
            entry = $dstr$key$value;
            bl = false;
            value = (String)entry.getValue();
            headersBuilder.add(key, (String)value);
        }
        return headersBuilder.build();
    }

    private final Map<String, String> toParams(RemoteExtensionQuery $this$toParams) {
        Object object = this.objectMapper.convertValue((Object)$this$toParams, (TypeReference)new TypeReference<Map<String, ? extends String>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026ap<String, String>>() {})");
        return (Map)object;
    }

    public OkHttpRemoteExtensionTransport(@NotNull ObjectMapper objectMapper, @NotNull OkHttpClient client, @NotNull RemoteExtensionConfig.RemoteExtensionTransportConfig.Http httpConfig) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpConfig, (String)"httpConfig");
        this.objectMapper = objectMapper;
        this.client = client;
        this.httpConfig = httpConfig;
        this.url = this.buildUrl(MapsKt.emptyMap());
    }

    public static final /* synthetic */ HttpUrl access$getUrl$p(OkHttpRemoteExtensionTransport $this) {
        return $this.url;
    }

    public static final /* synthetic */ Headers access$buildHeaders(OkHttpRemoteExtensionTransport $this, Map headers) {
        return $this.buildHeaders(headers);
    }

    public static final /* synthetic */ RemoteExtensionConfig.RemoteExtensionTransportConfig.Http access$getHttpConfig$p(OkHttpRemoteExtensionTransport $this) {
        return $this.httpConfig;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(OkHttpRemoteExtensionTransport $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(OkHttpRemoteExtensionTransport $this) {
        return $this.client;
    }

    public static final /* synthetic */ HttpUrl access$buildUrl(OkHttpRemoteExtensionTransport $this, Map additionalParams) {
        return $this.buildUrl(additionalParams);
    }

    public static final /* synthetic */ Map access$toParams(OkHttpRemoteExtensionTransport $this, RemoteExtensionQuery $this$access_u24toParams) {
        return $this.toParams($this$access_u24toParams);
    }
}

