/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.CanonicalPluginId;
import com.netflix.spinnaker.kork.plugins.ClassKind;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.api.ExtensionConfiguration;
import com.netflix.spinnaker.kork.plugins.api.PluginConfiguration;
import com.netflix.spinnaker.kork.plugins.api.PluginSdks;
import com.netflix.spinnaker.kork.plugins.config.ConfigFactory;
import com.netflix.spinnaker.kork.plugins.sdk.PluginSdksImpl;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000eH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u001a(\u0010\u0011\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0012\u001a\u00020\u00072\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tH\u0002\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createWithConstructor", "", "Ljava/lang/Class;", "classKind", "Lcom/netflix/spinnaker/kork/plugins/ClassKind;", "pluginSdkFactories", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/SdkFactory;", "configFactory", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;", "pluginWrapper", "Lorg/pf4j/PluginWrapper;", "isUnsafe", "", "newInstanceSafely", "kind", "Ljava/lang/reflect/Constructor;", "args", "validate", "", "Lorg/pf4j/PluginDescriptor;", "kork-plugins"})
public final class DslKt {
    private static final Logger log = LoggerFactory.getLogger((String)"com.netflix.spinnaker.kork.plugins.dsl");

    public static final boolean isUnsafe(@NotNull PluginWrapper $this$isUnsafe) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsafe, (String)"<this>");
        PluginDescriptor pluginDescriptor = $this$isUnsafe.getDescriptor();
        boolean bl = false;
        boolean bl2 = false;
        PluginDescriptor it = pluginDescriptor;
        boolean bl3 = false;
        return it instanceof SpinnakerPluginDescriptor ? ((SpinnakerPluginDescriptor)it).getUnsafe() : false;
    }

    public static final void validate(@NotNull PluginDescriptor $this$validate) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        String string = $this$validate.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.pluginId");
        CanonicalPluginId.Companion.validate(string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object createWithConstructor(@NotNull Class<?> $this$createWithConstructor, @NotNull ClassKind classKind, @NotNull List<? extends SdkFactory> pluginSdkFactories, @NotNull ConfigFactory configFactory, @Nullable PluginWrapper pluginWrapper) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$createWithConstructor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)classKind), (String)"classKind");
        Intrinsics.checkNotNullParameter(pluginSdkFactories, (String)"pluginSdkFactories");
        Intrinsics.checkNotNullParameter((Object)configFactory, (String)"configFactory");
        Object[] objectArray = $this$createWithConstructor.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"declaredConstructors");
        objectArray = objectArray;
        boolean bl = false;
        if (objectArray.length == 0) {
            log.debug("No injectable constructor found for '" + $this$createWithConstructor.getCanonicalName() + "': Using no-args constructor");
            return DslKt.newInstanceSafely($this$createWithConstructor, classKind);
        }
        if ($this$createWithConstructor.getDeclaredConstructors().length > 1) {
            throw new IntegrationException("More than one injectable constructor found for '" + $this$createWithConstructor.getCanonicalName() + "': Cannot initialize extension");
        }
        Constructor<?>[] constructorArray = $this$createWithConstructor.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"declaredConstructors");
        Constructor ctor = (Constructor)ArraysKt.first((Object[])constructorArray);
        Class<?>[] classArray = ctor.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"ctor.parameterTypes");
        Object[] $this$map$iv = classArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            PluginWrapper pluginWrapper2;
            Object object;
            void paramType;
            Class clazz = (Class)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)paramType, PluginWrapper.class) && classKind == ClassKind.PLUGIN) {
                object = pluginWrapper;
            } else if (Intrinsics.areEqual((Object)paramType, PluginSdks.class)) {
                Collection<Object> collection2;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = pluginSdkFactories;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    SdkFactory sdkFactory = (SdkFactory)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    Object object2 = it.create($this$createWithConstructor, pluginWrapper);
                    collection2.add(object2);
                }
                collection2 = (List)destination$iv$iv2;
                List list = collection2;
                object = new PluginSdksImpl(list);
            } else if (paramType.isAnnotationPresent(PluginConfiguration.class) && classKind == ClassKind.EXTENSION) {
                PluginDescriptor pluginDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)paramType, (String)"paramType");
                pluginWrapper2 = pluginWrapper;
                object = configFactory.createExtensionConfig((Class<?>)paramType, pluginWrapper2 == null ? null : ((pluginDescriptor = pluginWrapper2.getDescriptor()) == null ? null : pluginDescriptor.getPluginId()), paramType.getAnnotation(PluginConfiguration.class).value());
            } else if (paramType.isAnnotationPresent(PluginConfiguration.class) && classKind == ClassKind.PLUGIN) {
                PluginDescriptor pluginDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)paramType, (String)"paramType");
                pluginWrapper2 = pluginWrapper;
                object = configFactory.createPluginConfig((Class<?>)paramType, pluginWrapper2 == null ? null : ((pluginDescriptor = pluginWrapper2.getDescriptor()) == null ? null : pluginDescriptor.getPluginId()), paramType.getAnnotation(PluginConfiguration.class).value());
            } else if (paramType.isAnnotationPresent(ExtensionConfiguration.class)) {
                PluginDescriptor pluginDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)paramType, (String)"paramType");
                pluginWrapper2 = pluginWrapper;
                object = configFactory.createExtensionConfig((Class<?>)paramType, pluginWrapper2 == null ? null : ((pluginDescriptor = pluginWrapper2.getDescriptor()) == null ? null : pluginDescriptor.getPluginId()), paramType.getAnnotation(ExtensionConfiguration.class).value());
            } else {
                throw new IntegrationException("'" + $this$createWithConstructor.getCanonicalName() + "' has unsupported constructor argument type '" + paramType.getCanonicalName() + "'.  Expected argument classes should be annotated with @PluginConfiguration or implement PluginSdks.");
            }
            PluginWrapper pluginWrapper3 = object;
            collection.add(pluginWrapper3);
        }
        List args = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)ctor, (String)"ctor");
        return DslKt.newInstanceSafely(ctor, classKind, args);
    }

    @NotNull
    public static final Object newInstanceSafely(@NotNull Class<?> $this$newInstanceSafely, @NotNull ClassKind kind) {
        Object obj;
        Intrinsics.checkNotNullParameter($this$newInstanceSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        try {
            obj = $this$newInstanceSafely.newInstance();
        }
        catch (InstantiationException ie) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)iae);
        }
        catch (IllegalArgumentException iae) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)ite);
        }
        Object obj2 = obj;
        Intrinsics.checkNotNullExpressionValue(obj2, (String)"try {\n    newInstance()\n\u2026s.simpleName}'\", ite)\n  }");
        return obj2;
    }

    private static final Object newInstanceSafely(Constructor<?> $this$newInstanceSafely, ClassKind kind, List<? extends Object> args) {
        Object object;
        try {
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object = objectArray;
            object = $this$newInstanceSafely.newInstance(Arrays.copyOf(object, ((Object[])object).length));
        }
        catch (InstantiationException ie) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)iae);
        }
        catch (IllegalArgumentException iae) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new IntegrationException("Failed to instantiate " + kind + " '" + $this$newInstanceSafely.getDeclaringClass().getSimpleName() + "'", (Throwable)ite);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"try {\n    newInstance(*a\u2026s.simpleName}'\", ite)\n  }");
        return object2;
    }
}

