/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.finders;

import com.netflix.spinnaker.kork.plugins.finders.PluginRefPluginDescriptorFinder;
import com.netflix.spinnaker.kork.plugins.finders.SpinnakerManifestPluginDescriptorFinder;
import com.netflix.spinnaker.kork.plugins.finders.SpinnakerPropertiesPluginDescriptorFinder;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.CompoundPluginDescriptorFinder;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.RuntimeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/kork/plugins/finders/SpinnakerPluginDescriptorFinder;", "Lorg/pf4j/PluginDescriptorFinder;", "runtimeMode", "Lorg/pf4j/RuntimeMode;", "finders", "Lorg/pf4j/CompoundPluginDescriptorFinder;", "(Lorg/pf4j/RuntimeMode;Lorg/pf4j/CompoundPluginDescriptorFinder;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "find", "Lorg/pf4j/PluginDescriptor;", "pluginPath", "Ljava/nio/file/Path;", "isApplicable", "", "kork-plugins"})
public final class SpinnakerPluginDescriptorFinder
implements PluginDescriptorFinder {
    @NotNull
    private final RuntimeMode runtimeMode;
    @NotNull
    private final CompoundPluginDescriptorFinder finders;
    @NotNull
    private final Lazy log$delegate;

    public SpinnakerPluginDescriptorFinder(@NotNull RuntimeMode runtimeMode, @NotNull CompoundPluginDescriptorFinder finders) {
        Intrinsics.checkNotNullParameter((Object)runtimeMode, (String)"runtimeMode");
        Intrinsics.checkNotNullParameter((Object)finders, (String)"finders");
        this.runtimeMode = runtimeMode;
        this.finders = finders;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpinnakerPluginDescriptorFinder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        if (this.finders.size() > 0) {
            this.getLog().warn("Custom finders have been provided, skipping defaults");
        } else if (this.runtimeMode == RuntimeMode.DEVELOPMENT) {
            CompoundPluginDescriptorFinder spinnakerFinders = SpinnakerPluginDescriptorFinder._init_$addSpinnakerFinders(new CompoundPluginDescriptorFinder());
            this.finders.add((PluginDescriptorFinder)new PluginRefPluginDescriptorFinder((PluginDescriptorFinder)spinnakerFinders)).add((PluginDescriptorFinder)spinnakerFinders);
        } else {
            SpinnakerPluginDescriptorFinder._init_$addSpinnakerFinders(this.finders);
        }
    }

    public /* synthetic */ SpinnakerPluginDescriptorFinder(RuntimeMode runtimeMode, CompoundPluginDescriptorFinder compoundPluginDescriptorFinder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compoundPluginDescriptorFinder = new CompoundPluginDescriptorFinder();
        }
        this(runtimeMode, compoundPluginDescriptorFinder);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public boolean isApplicable(@NotNull Path pluginPath) {
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        return this.finders.isApplicable(pluginPath);
    }

    @NotNull
    public PluginDescriptor find(@NotNull Path pluginPath) {
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        PluginDescriptor pluginDescriptor = this.finders.find(pluginPath);
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"finders.find(pluginPath)");
        return pluginDescriptor;
    }

    private static final CompoundPluginDescriptorFinder _init_$addSpinnakerFinders(CompoundPluginDescriptorFinder finder) {
        CompoundPluginDescriptorFinder compoundPluginDescriptorFinder = finder.add((PluginDescriptorFinder)new SpinnakerPropertiesPluginDescriptorFinder(null, 1, null)).add((PluginDescriptorFinder)new SpinnakerManifestPluginDescriptorFinder());
        Intrinsics.checkNotNullExpressionValue((Object)compoundPluginDescriptorFinder, (String)"finder\n          .add(Sp\u2026PluginDescriptorFinder())");
        return compoundPluginDescriptorFinder;
    }
}

