/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.pluginref;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.spinnaker.kork.plugins.pluginref.InvalidPluginRefException;
import com.netflix.spinnaker.kork.plugins.pluginref.MalformedPluginRefException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/kork/plugins/pluginref/PluginRef;", "", "pluginPath", "", "classesDirs", "", "libsDirs", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getClassesDirs", "()Ljava/util/List;", "getLibsDirs", "getPluginPath", "()Ljava/lang/String;", "refPath", "Ljava/nio/file/Path;", "getRefPath", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "kork-plugins"})
public final class PluginRef {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pluginPath;
    @NotNull
    private final List<String> classesDirs;
    @NotNull
    private final List<String> libsDirs;
    @NotNull
    public static final String EXTENSION = ".plugin-ref";
    @NotNull
    private static final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();

    public PluginRef(@NotNull String pluginPath, @NotNull List<String> classesDirs, @NotNull List<String> libsDirs) {
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        Intrinsics.checkNotNullParameter(classesDirs, (String)"classesDirs");
        Intrinsics.checkNotNullParameter(libsDirs, (String)"libsDirs");
        this.pluginPath = pluginPath;
        this.classesDirs = classesDirs;
        this.libsDirs = libsDirs;
    }

    @NotNull
    public final String getPluginPath() {
        return this.pluginPath;
    }

    @NotNull
    public final List<String> getClassesDirs() {
        return this.classesDirs;
    }

    @NotNull
    public final List<String> getLibsDirs() {
        return this.libsDirs;
    }

    @JsonIgnore
    @NotNull
    public final Path getRefPath() {
        Path path = Paths.get(this.pluginPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(pluginPath)");
        return path;
    }

    @NotNull
    public final String component1() {
        return this.pluginPath;
    }

    @NotNull
    public final List<String> component2() {
        return this.classesDirs;
    }

    @NotNull
    public final List<String> component3() {
        return this.libsDirs;
    }

    @NotNull
    public final PluginRef copy(@NotNull String pluginPath, @NotNull List<String> classesDirs, @NotNull List<String> libsDirs) {
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        Intrinsics.checkNotNullParameter(classesDirs, (String)"classesDirs");
        Intrinsics.checkNotNullParameter(libsDirs, (String)"libsDirs");
        return new PluginRef(pluginPath, classesDirs, libsDirs);
    }

    public static /* synthetic */ PluginRef copy$default(PluginRef pluginRef, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = pluginRef.pluginPath;
        }
        if ((n & 2) != 0) {
            list = pluginRef.classesDirs;
        }
        if ((n & 4) != 0) {
            list2 = pluginRef.libsDirs;
        }
        return pluginRef.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "PluginRef(pluginPath=" + this.pluginPath + ", classesDirs=" + this.classesDirs + ", libsDirs=" + this.libsDirs + ")";
    }

    public int hashCode() {
        int result = this.pluginPath.hashCode();
        result = result * 31 + ((Object)this.classesDirs).hashCode();
        result = result * 31 + ((Object)this.libsDirs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginRef)) {
            return false;
        }
        PluginRef pluginRef = (PluginRef)other;
        if (!Intrinsics.areEqual((Object)this.pluginPath, (Object)pluginRef.pluginPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.classesDirs, pluginRef.classesDirs)) {
            return false;
        }
        return Intrinsics.areEqual(this.libsDirs, pluginRef.libsDirs);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/kork/plugins/pluginref/PluginRef$Companion;", "", "()V", "EXTENSION", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "isPluginRef", "", "path", "Ljava/nio/file/Path;", "loadPluginRef", "Lcom/netflix/spinnaker/kork/plugins/pluginref/PluginRef;", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isPluginRef(@Nullable Path path) {
            if (path == null) return false;
            if (!Files.isRegularFile(path, new LinkOption[0])) return false;
            String string = ((Object)path).toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (!StringsKt.endsWith$default((String)string3, (String)PluginRef.EXTENSION, (boolean)false, (int)2, null)) return false;
            return true;
        }

        @NotNull
        public final PluginRef loadPluginRef(@Nullable Path path) {
            if (!this.isPluginRef(path)) {
                throw new InvalidPluginRefException(path);
            }
            try {
                PluginRef pluginRef;
                ObjectMapper objectMapper = mapper;
                Path path2 = path;
                Intrinsics.checkNotNull((Object)path2);
                PluginRef ref = (PluginRef)objectMapper.readValue(path2.toFile(), PluginRef.class);
                if (ref.getRefPath().isAbsolute()) {
                    PluginRef pluginRef2 = ref;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginRef2, (String)"{\n          ref\n        }");
                    pluginRef = pluginRef2;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"ref");
                    pluginRef = PluginRef.copy$default(ref, ((Object)path.getParent().resolve(ref.getRefPath()).toAbsolutePath()).toString(), null, null, 6, null);
                }
                return pluginRef;
            }
            catch (IOException ex) {
                Path path3 = path;
                Intrinsics.checkNotNull((Object)path3);
                throw new MalformedPluginRefException(path3, ex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

