/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.kork.plugins.sdk.IdResolver;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.Ok3HttpClientRegistry;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal.CompositeOkHttpClientFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.PluginWrapper;
import org.springframework.core.env.Environment;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/HttpClientSdkFactory;", "Lcom/netflix/spinnaker/kork/plugins/sdk/SdkFactory;", "okHttpClientFactory", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/internal/CompositeOkHttpClientFactory;", "environment", "Lorg/springframework/core/env/Environment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "okHttp3ClientConfiguration", "Lcom/netflix/spinnaker/config/OkHttp3ClientConfiguration;", "(Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/internal/CompositeOkHttpClientFactory;Lorg/springframework/core/env/Environment;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/config/OkHttp3ClientConfiguration;)V", "create", "", "pluginClass", "Ljava/lang/Class;", "pluginWrapper", "Lorg/pf4j/PluginWrapper;", "kork-plugins"})
public final class HttpClientSdkFactory
implements SdkFactory {
    @NotNull
    private final CompositeOkHttpClientFactory okHttpClientFactory;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final OkHttp3ClientConfiguration okHttp3ClientConfiguration;

    public HttpClientSdkFactory(@NotNull CompositeOkHttpClientFactory okHttpClientFactory, @NotNull Environment environment, @NotNull ObjectMapper objectMapper, @NotNull OkHttp3ClientConfiguration okHttp3ClientConfiguration) {
        Intrinsics.checkNotNullParameter((Object)okHttpClientFactory, (String)"okHttpClientFactory");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)okHttp3ClientConfiguration, (String)"okHttp3ClientConfiguration");
        this.okHttpClientFactory = okHttpClientFactory;
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.okHttp3ClientConfiguration = okHttp3ClientConfiguration;
    }

    @Override
    @NotNull
    public Object create(@NotNull Class<?> pluginClass, @Nullable PluginWrapper pluginWrapper) {
        Intrinsics.checkNotNullParameter(pluginClass, (String)"pluginClass");
        return new Ok3HttpClientRegistry(IdResolver.INSTANCE.pluginOrExtensionId(pluginClass, pluginWrapper), this.environment, this.objectMapper, this.okHttpClientFactory, this.okHttp3ClientConfiguration);
    }
}

