/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientConfig;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.OkHttp3ClientFactory;
import com.netflix.spinnaker.okhttp.OkHttp3MetricsInterceptor;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/internal/DefaultOkHttp3ClientFactory;", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;", "okHttpClientHttp3MetricsInterceptor", "Lcom/netflix/spinnaker/okhttp/OkHttp3MetricsInterceptor;", "(Lcom/netflix/spinnaker/okhttp/OkHttp3MetricsInterceptor;)V", "convertToOkHttp", "Lcom/netflix/spinnaker/okhttp/OkHttpClientConfigurationProperties;", "config", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientConfig;", "create", "Lokhttp3/OkHttpClient;", "baseUrl", "", "supports", "", "kork-plugins"})
public final class DefaultOkHttp3ClientFactory
implements OkHttp3ClientFactory {
    @NotNull
    private final OkHttp3MetricsInterceptor okHttpClientHttp3MetricsInterceptor;

    public DefaultOkHttp3ClientFactory(@NotNull OkHttp3MetricsInterceptor okHttpClientHttp3MetricsInterceptor) {
        Intrinsics.checkNotNullParameter((Object)okHttpClientHttp3MetricsInterceptor, (String)"okHttpClientHttp3MetricsInterceptor");
        this.okHttpClientHttp3MetricsInterceptor = okHttpClientHttp3MetricsInterceptor;
    }

    @Override
    public boolean supports(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return StringsKt.startsWith$default((String)baseUrl, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)baseUrl, (String)"https://", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OkHttpClient create(@NotNull String baseUrl, @NotNull HttpClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        OkHttpClient.Builder builder = new OkHttp3ClientConfiguration(this.convertToOkHttp(config), this.okHttpClientHttp3MetricsInterceptor).create();
        boolean bl = false;
        boolean bl2 = false;
        OkHttpClient.Builder it = builder;
        boolean bl3 = false;
        if (config.getLogging().getLevel() != HttpClientConfig.LoggingConfig.LoggingLevel.NONE) {
            void $this$create_u24lambda_u2d1_u24lambda_u2d0;
            HttpLoggingInterceptor.Level level;
            HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
            boolean bl4 = false;
            boolean bl5 = false;
            HttpLoggingInterceptor httpLoggingInterceptor2 = httpLoggingInterceptor;
            OkHttpClient.Builder builder2 = it;
            boolean bl6 = false;
            HttpClientConfig.LoggingConfig.LoggingLevel loggingLevel = config.getLogging().getLevel();
            int n = loggingLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()];
            switch (n) {
                case 1: {
                    level = HttpLoggingInterceptor.Level.BASIC;
                    break;
                }
                case 2: {
                    level = HttpLoggingInterceptor.Level.HEADERS;
                    break;
                }
                case 3: {
                    level = HttpLoggingInterceptor.Level.BODY;
                    break;
                }
                default: {
                    throw new SystemException("Unsupported logging level: " + config.getLogging().getLevel());
                }
            }
            $this$create_u24lambda_u2d1_u24lambda_u2d0.level(level);
            Unit unit = Unit.INSTANCE;
            builder2.addInterceptor((Interceptor)httpLoggingInterceptor);
        }
        return builder.build();
    }

    private final OkHttpClientConfigurationProperties convertToOkHttp(HttpClientConfig config) {
        Duration it;
        boolean bl;
        boolean bl2;
        Duration duration;
        OkHttpClientConfigurationProperties okHttpClientConfigurationProperties = new OkHttpClientConfigurationProperties();
        boolean bl3 = false;
        boolean bl4 = false;
        OkHttpClientConfigurationProperties $this$convertToOkHttp_u24lambda_u2d6 = okHttpClientConfigurationProperties;
        boolean bl5 = false;
        Comparable<Duration> comparable = config.getConnectionPool().getKeepAlive();
        if (comparable != null) {
            duration = comparable;
            bl2 = false;
            bl = false;
            it = duration;
            boolean bl6 = false;
            $this$convertToOkHttp_u24lambda_u2d6.getConnectionPool().setKeepAliveDurationMs((int)it.toMillis());
        }
        comparable = config.getConnectionPool().getMaxIdleConnections();
        if (comparable != null) {
            duration = comparable;
            bl2 = false;
            bl = false;
            int it2 = ((Number)((Object)duration)).intValue();
            boolean bl7 = false;
            $this$convertToOkHttp_u24lambda_u2d6.getConnectionPool().setMaxIdleConnections(it2);
        }
        comparable = config.getConnection().getConnectTimeout();
        if (comparable != null) {
            duration = comparable;
            bl2 = false;
            bl = false;
            it = duration;
            boolean bl8 = false;
            $this$convertToOkHttp_u24lambda_u2d6.setConnectTimeoutMs(it.toMillis());
        }
        comparable = config.getConnection().getReadTimeout();
        if (comparable != null) {
            duration = comparable;
            bl2 = false;
            bl = false;
            it = duration;
            boolean bl9 = false;
            $this$convertToOkHttp_u24lambda_u2d6.setReadTimeoutMs(it.toMillis());
        }
        $this$convertToOkHttp_u24lambda_u2d6.setRetryOnConnectionFailure(config.getConnection().isRetryOnConnectionFailure());
        if (config.getSecurity().getKeyStorePath() != null && config.getSecurity().getTrustStorePath() != null) {
            $this$convertToOkHttp_u24lambda_u2d6.setKeyStore(config.getSecurity().getKeyStorePath().toFile());
            $this$convertToOkHttp_u24lambda_u2d6.setKeyStoreType(config.getSecurity().getKeyStoreType());
            $this$convertToOkHttp_u24lambda_u2d6.setKeyStorePassword(config.getSecurity().getKeyStorePassword());
            $this$convertToOkHttp_u24lambda_u2d6.setTrustStore(config.getSecurity().getTrustStorePath().toFile());
            $this$convertToOkHttp_u24lambda_u2d6.setTrustStoreType(config.getSecurity().getTrustStoreType());
            $this$convertToOkHttp_u24lambda_u2d6.setTrustStorePassword(config.getSecurity().getTrustStorePassword());
            $this$convertToOkHttp_u24lambda_u2d6.setTlsVersions(config.getSecurity().getTlsVersions());
            $this$convertToOkHttp_u24lambda_u2d6.setCipherSuites(config.getSecurity().getCipherSuites());
        }
        return okHttpClientConfigurationProperties;
    }

    @Override
    @NotNull
    public String normalizeBaseUrl(@NotNull String baseUrl) {
        return OkHttp3ClientFactory.DefaultImpls.normalizeBaseUrl(this, baseUrl);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpClientConfig.LoggingConfig.LoggingLevel.values().length];
            nArray[HttpClientConfig.LoggingConfig.LoggingLevel.BASIC.ordinal()] = 1;
            nArray[HttpClientConfig.LoggingConfig.LoggingLevel.HEADERS.ordinal()] = 2;
            nArray[HttpClientConfig.LoggingConfig.LoggingLevel.BODY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

