/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.events.PluginDownloaded;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.PluginManager;
import org.pf4j.PluginRuntimeException;
import org.pf4j.PluginWrapper;
import org.pf4j.VersionManager;
import org.pf4j.update.PluginInfo;
import org.pf4j.update.UpdateManager;
import org.pf4j.update.UpdateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007H\u0016J\u001c\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\u001c\u0010#\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010$\u001a\u0004\u0018\u00010\u0012*\u00020\u0019H\u0002J\u001c\u0010%\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;", "Lorg/pf4j/update/UpdateManager;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "pluginManager", "Lorg/pf4j/PluginManager;", "repositories", "", "Lorg/pf4j/update/UpdateRepository;", "(Lorg/springframework/context/ApplicationEventPublisher;Lorg/pf4j/PluginManager;Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "downloadPluginRelease", "Ljava/nio/file/Path;", "pluginId", "", "version", "downloadPluginReleases", "", "pluginInfoReleases", "Lcom/netflix/spinnaker/kork/plugins/update/release/PluginInfoRelease;", "downloadPluginReleases$kork_plugins", "getLastPluginRelease", "Lorg/pf4j/update/PluginInfo$PluginRelease;", "id", "serviceName", "getPlugins", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo;", "installPlugin", "", "updatePlugin", "download", "write", "downloaded", "Companion", "kork-plugins"})
public final class SpinnakerUpdateManager
extends UpdateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();

    public SpinnakerUpdateManager(@NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull PluginManager pluginManager, @NotNull List<? extends UpdateRepository> repositories) {
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        super(pluginManager, repositories);
        this.applicationEventPublisher = applicationEventPublisher;
        this.pluginManager = pluginManager;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpinnakerUpdateManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(((Object)((Object)this.this$0)).getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SpinnakerPluginInfo> getPlugins() {
        boolean bl = false;
        List plugins = new ArrayList();
        for (UpdateRepository repository : this.getRepositories()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = repository.getPlugins().values();
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PluginInfo pluginInfo = (PluginInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                SpinnakerPluginInfo spinnakerPluginInfo = (SpinnakerPluginInfo)((Object)objectMapper.convertValue((Object)it, SpinnakerPluginInfo.class));
                collection.add(spinnakerPluginInfo);
            }
            CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)plugins);
        }
        return plugins;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Path> downloadPluginReleases$kork_plugins(@NotNull Set<PluginInfoRelease> pluginInfoReleases) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginInfoReleases, (String)"pluginInfoReleases");
        Iterable $this$mapNotNull$iv = pluginInfoReleases;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path path;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PluginInfoRelease it = (PluginInfoRelease)element$iv$iv;
            boolean bl2 = false;
            if (this.download(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Path it$iv$iv = path;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final Path download(PluginInfoRelease $this$download) {
        PluginWrapper loadedPlugin;
        if ($this$download.getProps().url == null) {
            Collection collection = $this$download.getProps().getRemoteExtensions();
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.getLog().info("Nothing to download - plugin '{}' is a remote plugin and there is no in-process plugin binary.", (Object)$this$download.getPluginId());
                return null;
            }
        }
        if ((loadedPlugin = this.pluginManager.getPlugin($this$download.getPluginId())) != null) {
            String loadedPluginVersion = loadedPlugin.getDescriptor().getVersion();
            if (Intrinsics.areEqual((Object)loadedPluginVersion, (Object)"unspecified") || this.pluginManager.getVersionManager().compareVersions($this$download.getProps().version, loadedPluginVersion) > 0) {
                Object[] objectArray = new Object[]{$this$download.getProps().version, $this$download.getPluginId(), loadedPluginVersion};
                this.getLog().debug("Newer version '{}' of plugin '{}' found, deleting previous version '{}'", objectArray);
                boolean deleted = this.pluginManager.deletePlugin(loadedPlugin.getPluginId());
                if (!deleted) {
                    throw new IntegrationException("Unable to update plugin '" + $this$download.getPluginId() + "' to version '" + $this$download.getProps().version + "', failed to delete previous version '" + loadedPluginVersion + "}'");
                }
            } else {
                return null;
            }
        }
        this.getLog().debug("Downloading plugin '{}' with version '{}'", (Object)$this$download.getPluginId(), (Object)$this$download.getProps().version);
        String string = $this$download.getPluginId();
        String deleted = $this$download.getProps().version;
        Intrinsics.checkNotNullExpressionValue((Object)deleted, (String)"props.version");
        Path tmpPath = this.downloadPluginRelease(string, deleted);
        Object object = this.pluginManager.getPluginsRoot();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginManager.pluginsRoot");
        Path downloadedPluginPath = this.write((Path)object, $this$download.getPluginId(), tmpPath);
        this.getLog().debug("Downloaded plugin '{}'", (Object)$this$download.getPluginId());
        String string2 = $this$download.getPluginId();
        object = $this$download.getProps().version;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"props.version");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PluginDownloaded(this, PluginDownloaded.Status.SUCCEEDED, string2, (String)object));
        return downloadedPluginPath;
    }

    @Nullable
    public final PluginInfo.PluginRelease getLastPluginRelease(@NotNull String id, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        PluginInfo pluginInfo = (PluginInfo)this.getPluginsMap().get(id);
        if (pluginInfo == null) {
            this.getLog().warn("Unable to find plugin info for '{}'", (Object)id);
            return null;
        }
        VersionManager versionManager = this.pluginManager.getVersionManager();
        boolean bl = false;
        Map lastPluginRelease = new LinkedHashMap();
        for (PluginInfo.PluginRelease release : pluginInfo.releases) {
            boolean bl2;
            PluginInfo.PluginRelease pluginRelease;
            Object object = release.requires;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"release.requires");
            if (!StringsKt.contains((CharSequence)((CharSequence)object), (CharSequence)serviceName, (boolean)true)) continue;
            if (lastPluginRelease.get(id) == null) {
                object = lastPluginRelease;
                Intrinsics.checkNotNullExpressionValue((Object)release, (String)"release");
                pluginRelease = release;
                bl2 = false;
                object.put(id, pluginRelease);
                continue;
            }
            String string = release.version;
            Object v = lastPluginRelease.get(id);
            Intrinsics.checkNotNull(v);
            if (versionManager.compareVersions(string, ((PluginInfo.PluginRelease)v).version) <= 0) continue;
            object = lastPluginRelease;
            Intrinsics.checkNotNullExpressionValue((Object)release, (String)"release");
            pluginRelease = release;
            bl2 = false;
            object.put(id, pluginRelease);
        }
        return (PluginInfo.PluginRelease)lastPluginRelease.get(id);
    }

    @NotNull
    public final Path downloadPluginRelease(@NotNull String pluginId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Path path = this.downloadPlugin(pluginId, version);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"downloadPlugin(pluginId, version)");
        return path;
    }

    private final Path write(Path $this$write, String pluginId, Path downloaded) {
        if (Intrinsics.areEqual((Object)this.pluginManager.getPluginsRoot(), (Object)$this$write)) {
            Path file = $this$write.resolve(pluginId + "-" + downloaded.getFileName());
            new File(((Object)$this$write).toString()).mkdirs();
            try {
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Path path = Files.move(downloaded, file, copyOptionArray);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"move(downloaded, file, S\u2026yOption.REPLACE_EXISTING)");
                return path;
            }
            catch (IOException e) {
                Object[] objectArray = new Object[]{file};
                throw new PluginRuntimeException((Throwable)e, "Failed to write file '{}' to plugins folder", objectArray);
            }
        }
        throw new UnsupportedOperationException("This operation is only supported on the specified plugins root directory.");
    }

    public synchronized boolean installPlugin(@Nullable String id, @Nullable String version) {
        throw new UnsupportedOperationException("UpdateManager installPlugin is not supported");
    }

    public boolean updatePlugin(@Nullable String id, @Nullable String version) {
        throw new UnsupportedOperationException("UpdateManager updatePlugin is not supported");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager$Companion;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

