/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.downloader;

import com.netflix.spinnaker.kork.plugins.update.downloader.SupportingFileDownloader;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import io.github.resilience4j.retry.Retry;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/downloader/Front50FileDownloader;", "Lcom/netflix/spinnaker/kork/plugins/update/downloader/SupportingFileDownloader;", "okHttpClient", "Lokhttp3/OkHttpClient;", "front50BaseUrl", "Ljava/net/URL;", "(Lokhttp3/OkHttpClient;Ljava/net/URL;)V", "downloadFile", "Ljava/nio/file/Path;", "fileUrl", "supports", "", "url", "Companion", "kork-plugins"})
public final class Front50FileDownloader
implements SupportingFileDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient okHttpClient;
    @NotNull
    private final URL front50BaseUrl;
    private static final Path downloadDir = Files.createTempDirectory("plugin-downloads", new FileAttribute[0]);
    private static final Retry retry = Retry.ofDefaults((String)"plugin-front50-downloader");
    @NotNull
    private static final String binaryExtension = ".zip";

    public Front50FileDownloader(@NotNull OkHttpClient okHttpClient, @NotNull URL front50BaseUrl) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)front50BaseUrl, (String)"front50BaseUrl");
        this.okHttpClient = okHttpClient;
        this.front50BaseUrl = front50BaseUrl;
    }

    @Override
    public boolean supports(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Intrinsics.areEqual((Object)url.getHost(), (Object)this.front50BaseUrl.getHost());
    }

    @NotNull
    public Path downloadFile(@NotNull URL fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Request request = new Request.Builder().header("Accept", "application/zip,application/octet-stream").url(fileUrl).build();
        Response response = (Response)retry.executeCallable(() -> Front50FileDownloader.downloadFile$lambda-0(this, request));
        ResponseBody body = response.body();
        if (!response.isSuccessful() || body == null) {
            throw new NotFoundException("Plugin binary could not be downloaded, received HTTP " + response.code());
        }
        Path path = downloadDir.resolve(Paths.get(fileUrl.getPath() + binaryExtension, new String[0]).getFileName());
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        Files.write(it, body.bytes(), new OpenOption[0]);
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"downloadDir.resolve(Path\u2026e(it, body.bytes())\n    }");
        return path2;
    }

    private static final Response downloadFile$lambda-0(Front50FileDownloader this$0, Request $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        return this$0.okHttpClient.newCall($request).execute();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/downloader/Front50FileDownloader$Companion;", "", "()V", "binaryExtension", "", "downloadDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "retry", "Lio/github/resilience4j/retry/Retry;", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

