/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.repository;

import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.update.internal.Front50Service;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import io.github.resilience4j.retry.Retry;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.pf4j.update.FileDownloader;
import org.pf4j.update.FileVerifier;
import org.pf4j.update.SimpleFileDownloader;
import org.pf4j.update.UpdateRepository;
import org.pf4j.update.verifier.CompoundVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/repository/Front50UpdateRepository;", "Lorg/pf4j/update/UpdateRepository;", "repositoryName", "", "url", "Ljava/net/URL;", "downloader", "Lorg/pf4j/update/FileDownloader;", "verifier", "Lorg/pf4j/update/FileVerifier;", "front50Service", "Lcom/netflix/spinnaker/kork/plugins/update/internal/Front50Service;", "(Ljava/lang/String;Ljava/net/URL;Lorg/pf4j/update/FileDownloader;Lorg/pf4j/update/FileVerifier;Lcom/netflix/spinnaker/kork/plugins/update/internal/Front50Service;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "plugins", "", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo;", "getFileDownloader", "getFileVerifier", "getId", "getPlugin", "id", "getPlugins", "getUrl", "refresh", "", "Companion", "kork-plugins"})
public final class Front50UpdateRepository
implements UpdateRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String repositoryName;
    @NotNull
    private final URL url;
    @NotNull
    private final FileDownloader downloader;
    @NotNull
    private final FileVerifier verifier;
    @NotNull
    private final Front50Service front50Service;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private Map<String, SpinnakerPluginInfo> plugins;
    private static final Retry retry = Retry.ofDefaults((String)"front50-update-repository");

    public Front50UpdateRepository(@NotNull String repositoryName, @NotNull URL url, @NotNull FileDownloader downloader, @NotNull FileVerifier verifier, @NotNull Front50Service front50Service) {
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)front50Service, (String)"front50Service");
        this.repositoryName = repositoryName;
        this.url = url;
        this.downloader = downloader;
        this.verifier = verifier;
        this.front50Service = front50Service;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Front50UpdateRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        boolean bl = false;
        this.plugins = new LinkedHashMap();
    }

    public /* synthetic */ Front50UpdateRepository(String string, URL uRL, FileDownloader fileDownloader, FileVerifier fileVerifier, Front50Service front50Service, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileDownloader = (FileDownloader)new SimpleFileDownloader();
        }
        if ((n & 8) != 0) {
            fileVerifier = (FileVerifier)new CompoundVerifier();
        }
        this(string, uRL, fileDownloader, fileVerifier, front50Service);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public URL getUrl() {
        return this.url;
    }

    @NotNull
    public String getId() {
        return this.repositoryName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, SpinnakerPluginInfo> getPlugins() {
        Map<String, SpinnakerPluginInfo> map;
        Map<String, SpinnakerPluginInfo> map2 = this.plugins;
        boolean bl = false;
        if (map2.isEmpty()) {
            void $this$associateByTo$iv;
            boolean bl2 = false;
            this.getLog().debug("Populating plugin info cache from front50");
            Response response = (Response)retry.executeSupplier(() -> Front50UpdateRepository.getPlugins$lambda-2$lambda-0(this));
            if (!response.isSuccessful()) {
                ResponseBody responseBody = response.errorBody();
                String string = responseBody == null ? null : responseBody.string();
                this.getLog().error("Failed listing plugin info from front50. This service may not download plugins that it needs: {}", (Object)(string == null ? response.message() : string));
                boolean bl3 = false;
                return new LinkedHashMap();
            }
            Object object = response.body();
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"response.body()!!");
            object2 = (Iterable)object2;
            Map<String, SpinnakerPluginInfo> destination$iv = this.plugins;
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                void it;
                SpinnakerPluginInfo spinnakerPluginInfo = (SpinnakerPluginInfo)((Object)element$iv);
                Map<String, SpinnakerPluginInfo> map3 = destination$iv;
                boolean bl4 = false;
                String string = it.id;
                map3.put(string, (SpinnakerPluginInfo)((Object)element$iv));
            }
            map = destination$iv;
        } else {
            map = map2;
        }
        return map;
    }

    @NotNull
    public SpinnakerPluginInfo getPlugin(@NotNull String id) {
        SpinnakerPluginInfo spinnakerPluginInfo;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Map<String, SpinnakerPluginInfo> $this$getOrPut$iv = this.plugins;
        boolean $i$f$getOrPut = false;
        SpinnakerPluginInfo value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            Response response = this.front50Service.getById(id).execute();
            if (!response.isSuccessful()) {
                throw new SystemException("Unable to get the requested plugin info `" + id + "` from front50", response.message());
            }
            Object object = response.body();
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"response.body()!!");
            SpinnakerPluginInfo answer$iv = (SpinnakerPluginInfo)((Object)object2);
            $this$getOrPut$iv.put(id, answer$iv);
            spinnakerPluginInfo = answer$iv;
        } else {
            spinnakerPluginInfo = value$iv;
        }
        return spinnakerPluginInfo;
    }

    @NotNull
    public FileVerifier getFileVerifier() {
        return this.verifier;
    }

    @NotNull
    public FileDownloader getFileDownloader() {
        return this.downloader;
    }

    public void refresh() {
        this.plugins.clear();
    }

    private static final Response getPlugins$lambda-2$lambda-0(Front50UpdateRepository this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.front50Service.listAll().execute();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/repository/Front50UpdateRepository$Companion;", "", "()V", "retry", "Lio/github/resilience4j/retry/Retry;", "kotlin.jvm.PlatformType", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

