/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.v2;

import com.netflix.spinnaker.kork.plugins.api.events.SpinnakerEventListener;
import java.lang.reflect.Method;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/netflix/spinnaker/kork/plugins/v2/SpringEventListenerAdapter;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/context/ApplicationEvent;", "eventListener", "Lcom/netflix/spinnaker/kork/plugins/api/events/SpinnakerEventListener;", "(Lcom/netflix/spinnaker/kork/plugins/api/events/SpinnakerEventListener;)V", "getEventListener$kork_plugins", "()Lcom/netflix/spinnaker/kork/plugins/api/events/SpinnakerEventListener;", "interestedType", "Ljava/lang/Class;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "findEventType", "type", "Lorg/springframework/core/ResolvableType;", "onApplicationEvent", "", "event", "kork-plugins"})
public final class SpringEventListenerAdapter
implements ApplicationListener<ApplicationEvent> {
    @NotNull
    private final SpinnakerEventListener<?> eventListener;
    @NotNull
    private final Lazy log$delegate;
    @Nullable
    private final Class<?> interestedType;

    public SpringEventListenerAdapter(@NotNull SpinnakerEventListener<?> eventListener) {
        Intrinsics.checkNotNullParameter(eventListener, (String)"eventListener");
        this.eventListener = eventListener;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpringEventListenerAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.interestedType = this.findEventType(this.eventListener);
    }

    @NotNull
    public final SpinnakerEventListener<?> getEventListener$kork_plugins() {
        return this.eventListener;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void onApplicationEvent(@NotNull ApplicationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.interestedType != null && this.interestedType.isAssignableFrom(event.getClass())) {
            Object[] objectArray = new Class[]{this.interestedType};
            Method method = this.eventListener.getClass().getMethod("onApplicationEvent", (Class<?>[])objectArray);
            method.setAccessible(true);
            objectArray = new Object[]{event};
            ReflectionUtils.invokeMethod((Method)method, this.eventListener, (Object[])objectArray);
        }
    }

    private final Class<?> findEventType(SpinnakerEventListener<?> eventListener) {
        Class<?> clazz;
        try {
            ResolvableType eventListenerType = ResolvableType.forInstance(eventListener);
            Intrinsics.checkNotNullExpressionValue((Object)eventListenerType, (String)"eventListenerType");
            clazz = this.findEventType(eventListenerType);
        }
        catch (Exception e) {
            this.getLog().warn("Unable to resolve event type for listener, all events will be ignored: {}", (Object)eventListener.getExtensionClass().getSimpleName());
            return null;
        }
        return clazz;
    }

    private final Class<?> findEventType(ResolvableType type) {
        Class clazz;
        Object object;
        ResolvableType resolvableType;
        block4: {
            if (!Intrinsics.areEqual((Object)type.getSuperType().getRawClass().getName(), (Object)"java.lang.Object")) {
                ResolvableType resolvableType2 = type.getSuperType();
                Intrinsics.checkNotNullExpressionValue((Object)resolvableType2, (String)"type.superType");
                return this.findEventType(resolvableType2);
            }
            resolvableType = type.getInterfaces();
            Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"type.interfaces");
            Object[] $this$firstOrNull$iv = (Object[])resolvableType;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ResolvableType it = (ResolvableType)element$iv;
                boolean bl = false;
                Class clazz2 = it.getRawClass();
                Intrinsics.checkNotNull((Object)clazz2);
                if (!SpinnakerEventListener.class.isAssignableFrom(clazz2)) continue;
                object = element$iv;
                break block4;
            }
            object = null;
        }
        ResolvableType resolvableType3 = (ResolvableType)object;
        if (resolvableType3 == null) {
            clazz = null;
        } else {
            int[] nArray = new int[]{0};
            resolvableType = resolvableType3.getGeneric(nArray);
            clazz = resolvableType == null ? null : resolvableType.getRawClass();
        }
        return clazz;
    }
}

