/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.v2;

import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.config.ConfigFactory;
import com.netflix.spinnaker.kork.plugins.v2.ApplicationEventListenerBeanPostProcessor;
import com.netflix.spinnaker.kork.plugins.v2.context.ComponentScanningCustomizer;
import com.netflix.spinnaker.kork.plugins.v2.context.PluginApplicationContextCustomizer;
import com.netflix.spinnaker.kork.plugins.v2.context.PluginConfigurationRegisteringCustomizer;
import com.netflix.spinnaker.kork.plugins.v2.context.PluginSdksRegisteringCustomizer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/kork/plugins/v2/SpringPluginInitializer;", "Lorg/springframework/context/ApplicationContextAware;", "plugin", "Lorg/pf4j/Plugin;", "pluginWrapper", "Lorg/pf4j/PluginWrapper;", "pluginApplicationContext", "Lorg/springframework/context/support/GenericApplicationContext;", "(Lorg/pf4j/Plugin;Lorg/pf4j/PluginWrapper;Lorg/springframework/context/support/GenericApplicationContext;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "setApplicationContext", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "kork-plugins"})
public final class SpringPluginInitializer
implements ApplicationContextAware {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final PluginWrapper pluginWrapper;
    @NotNull
    private final GenericApplicationContext pluginApplicationContext;
    @NotNull
    private final Lazy log$delegate;

    public SpringPluginInitializer(@NotNull Plugin plugin, @NotNull PluginWrapper pluginWrapper, @NotNull GenericApplicationContext pluginApplicationContext) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)pluginWrapper, (String)"pluginWrapper");
        Intrinsics.checkNotNullParameter((Object)pluginApplicationContext, (String)"pluginApplicationContext");
        this.plugin = plugin;
        this.pluginWrapper = pluginWrapper;
        this.pluginApplicationContext = pluginApplicationContext;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpringPluginInitializer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new SystemException("ApplicationContext must be configurable");
        }
        this.getLog().info("Initializing '" + this.pluginWrapper.getPluginId() + "'");
        this.pluginApplicationContext.setClassLoader(this.pluginWrapper.getPluginClassLoader());
        this.pluginApplicationContext.setResourceLoader((ResourceLoader)new DefaultResourceLoader(this.pluginWrapper.getPluginClassLoader()));
        this.pluginApplicationContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new ApplicationEventListenerBeanPostProcessor());
        Object[] objectArray = new PluginApplicationContextCustomizer[3];
        Object object = applicationContext.getBean(ConfigFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applicationContext.getBe\u2026onfigFactory::class.java)");
        objectArray[0] = new PluginConfigurationRegisteringCustomizer((ConfigFactory)object, null, 2, null);
        objectArray[1] = new PluginSdksRegisteringCustomizer((ConfigurableApplicationContext)applicationContext);
        objectArray[2] = new ComponentScanningCustomizer();
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginApplicationContextCustomizer it = (PluginApplicationContextCustomizer)element$iv;
            boolean bl = false;
            it.accept(this.plugin, this.pluginApplicationContext);
        }
        this.pluginApplicationContext.refresh();
    }
}

