/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.config;

import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.config.ConfigCoordinates;
import com.netflix.spinnaker.kork.plugins.config.ConfigResolver;
import com.netflix.spinnaker.kork.plugins.config.ExtensionConfigCoordinates;
import com.netflix.spinnaker.kork.plugins.config.PluginConfigCoordinates;
import com.netflix.spinnaker.kork.plugins.config.SystemExtensionConfigCoordinates;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0004\u0018\u00010\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tJ&\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\tJ\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;", "", "configResolver", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigResolver;", "(Lcom/netflix/spinnaker/kork/plugins/config/ConfigResolver;)V", "createExtensionConfig", "configClass", "Ljava/lang/Class;", "pluginId", "", "extensionConfigId", "createPluginConfig", "pluginConfigId", "resolveConfiguration", "coordinates", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigCoordinates;", "kork-plugins"})
public final class ConfigFactory {
    @NotNull
    private final ConfigResolver configResolver;

    public ConfigFactory(@NotNull ConfigResolver configResolver) {
        Intrinsics.checkNotNullParameter((Object)configResolver, (String)"configResolver");
        this.configResolver = configResolver;
    }

    @Nullable
    public final Object createExtensionConfig(@NotNull Class<?> configClass, @Nullable String pluginId, @NotNull String extensionConfigId) {
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Intrinsics.checkNotNullParameter((Object)extensionConfigId, (String)"extensionConfigId");
        ConfigCoordinates coordinates = pluginId != null ? (ConfigCoordinates)new ExtensionConfigCoordinates(pluginId, extensionConfigId, null, 4, null) : (ConfigCoordinates)new SystemExtensionConfigCoordinates(extensionConfigId);
        return this.resolveConfiguration(coordinates, configClass);
    }

    @Nullable
    public final Object createPluginConfig(@NotNull Class<?> configClass, @Nullable String pluginId, @NotNull String pluginConfigId) {
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Intrinsics.checkNotNullParameter((Object)pluginConfigId, (String)"pluginConfigId");
        if (pluginId != null) {
            return this.resolveConfiguration(new PluginConfigCoordinates(pluginId, pluginConfigId), configClass);
        }
        return null;
    }

    private final Object resolveConfiguration(ConfigCoordinates coordinates, Class<?> configClass) {
        Class<?> clazz = configClass;
        boolean bl = false;
        boolean bl2 = false;
        Class<?> it = clazz;
        boolean bl3 = false;
        Object obj = this.configResolver.resolve(coordinates, it);
        if (obj == null) {
            throw new SystemException("Could not resolve configuration '" + configClass.getSimpleName() + "' with coordinates '" + coordinates.toPointer() + "'");
        }
        return obj;
    }
}

