/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.finders;

import com.netflix.spinnaker.kork.plugins.pluginref.PluginRef;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/kork/plugins/finders/PluginRefPluginDescriptorFinder;", "Lorg/pf4j/PluginDescriptorFinder;", "descriptorFinder", "(Lorg/pf4j/PluginDescriptorFinder;)V", "find", "Lorg/pf4j/PluginDescriptor;", "pluginPath", "Ljava/nio/file/Path;", "isApplicable", "", "kork-plugins"})
public final class PluginRefPluginDescriptorFinder
implements PluginDescriptorFinder {
    @NotNull
    private final PluginDescriptorFinder descriptorFinder;

    public PluginRefPluginDescriptorFinder(@NotNull PluginDescriptorFinder descriptorFinder) {
        Intrinsics.checkNotNullParameter((Object)descriptorFinder, (String)"descriptorFinder");
        this.descriptorFinder = descriptorFinder;
    }

    public boolean isApplicable(@Nullable Path pluginPath) {
        if (!PluginRef.Companion.isPluginRef(pluginPath)) {
            return false;
        }
        PluginRef ref = PluginRef.Companion.loadPluginRef(pluginPath);
        return this.descriptorFinder.isApplicable(ref.getRefPath());
    }

    @NotNull
    public PluginDescriptor find(@Nullable Path pluginPath) {
        PluginRef ref = PluginRef.Companion.loadPluginRef(pluginPath);
        PluginDescriptor pluginDescriptor = this.descriptorFinder.find(ref.getRefPath());
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"descriptorFinder.find(ref.refPath)");
        return pluginDescriptor;
    }
}

