/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.remote.extension.transport.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.api.plugins.remote.RemoteExtensionConfig;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionPayload;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionQuery;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionResponse;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.RemoteExtensionTransport;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.http.OkHttpRemoteExtensionTransportException;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/http/OkHttpRemoteExtensionTransport;", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionTransport;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "client", "Lokhttp3/OkHttpClient;", "httpConfig", "Lcom/netflix/spinnaker/kork/api/plugins/remote/RemoteExtensionConfig$RemoteExtensionTransportConfig$Http;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lokhttp3/OkHttpClient;Lcom/netflix/spinnaker/kork/api/plugins/remote/RemoteExtensionConfig$RemoteExtensionTransportConfig$Http;)V", "url", "Lokhttp3/HttpUrl;", "buildHeaders", "Lokhttp3/Headers;", "headers", "", "", "buildUrl", "additionalParams", "invoke", "", "remoteExtensionPayload", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionPayload;", "read", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionResponse;", "remoteExtensionQuery", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/transport/RemoteExtensionQuery;", "write", "toParams", "kork-plugins"})
public final class OkHttpRemoteExtensionTransport
implements RemoteExtensionTransport {
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final RemoteExtensionConfig.RemoteExtensionTransportConfig.Http httpConfig;
    @NotNull
    private final HttpUrl url;

    public OkHttpRemoteExtensionTransport(@NotNull ObjectMapper objectMapper, @NotNull OkHttpClient client, @NotNull RemoteExtensionConfig.RemoteExtensionTransportConfig.Http httpConfig) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)httpConfig, (String)"httpConfig");
        this.objectMapper = objectMapper;
        this.client = client;
        this.httpConfig = httpConfig;
        this.url = this.buildUrl(MapsKt.emptyMap());
    }

    @Override
    public void invoke(@NotNull RemoteExtensionPayload remoteExtensionPayload) {
        Intrinsics.checkNotNullParameter((Object)remoteExtensionPayload, (String)"remoteExtensionPayload");
        AuthenticatedRequest.propagate(() -> OkHttpRemoteExtensionTransport.invoke$lambda-0(this, remoteExtensionPayload)).call();
    }

    @Override
    @NotNull
    public RemoteExtensionResponse write(@NotNull RemoteExtensionPayload remoteExtensionPayload) {
        Intrinsics.checkNotNullParameter((Object)remoteExtensionPayload, (String)"remoteExtensionPayload");
        Object v = AuthenticatedRequest.propagate(() -> OkHttpRemoteExtensionTransport.write$lambda-1(this, remoteExtensionPayload)).call();
        Intrinsics.checkNotNullExpressionValue(v, (String)"propagate {\n      val re\u2026:class.java)\n    }.call()");
        return (RemoteExtensionResponse)v;
    }

    @Override
    @NotNull
    public RemoteExtensionResponse read(@NotNull RemoteExtensionQuery remoteExtensionQuery) {
        Intrinsics.checkNotNullParameter((Object)remoteExtensionQuery, (String)"remoteExtensionQuery");
        Object v = AuthenticatedRequest.propagate(() -> OkHttpRemoteExtensionTransport.read$lambda-2(this, remoteExtensionQuery)).call();
        Intrinsics.checkNotNullExpressionValue(v, (String)"propagate {\n      val re\u2026:class.java)\n    }.call()");
        return (RemoteExtensionResponse)v;
    }

    private final HttpUrl buildUrl(Map<String, String> additionalParams) {
        Object object;
        Object object2 = this.httpConfig.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"httpConfig.url");
        HttpUrl httpUrl = HttpUrl.Companion.parse((String)object2);
        HttpUrl.Builder builder = object = httpUrl == null ? null : httpUrl.newBuilder();
        if (object == null) {
            throw new IntegrationException("Unable to parse url '" + this.httpConfig.getUrl() + "'");
        }
        HttpUrl.Builder httpUrlBuilder = object;
        object = this.httpConfig.getQueryParams();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"httpConfig.queryParams");
        Map $this$forEach$iv = MapsKt.plus((Map)object, additionalParams);
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            httpUrlBuilder.addQueryParameter((String)k, (String)it.getValue());
        }
        return httpUrlBuilder.build();
    }

    private final Headers buildHeaders(Map<String, String> headers) {
        Object value;
        boolean bl;
        Map.Entry entry;
        String key;
        Map.Entry $dstr$key$value;
        Map.Entry<Object, Object> element$iv;
        Map<String, String> $this$forEach$iv;
        Headers.Builder headersBuilder = new Headers.Builder();
        Map map = AuthenticatedRequest.getAuthenticationHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAuthenticationHeaders()");
        boolean $i$f$forEach = false;
        Map<String, String> map2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<Object, Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$key$value = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry entry2 = $dstr$key$value;
            boolean bl4 = false;
            key = (String)entry2.getKey();
            entry = $dstr$key$value;
            bl = false;
            value = (Optional)entry.getValue();
            if (!((Optional)value).isPresent()) continue;
            String string = key.toString();
            entry = ((Optional)value).get();
            Intrinsics.checkNotNullExpressionValue(entry, (String)"value.get()");
            headersBuilder.add(string, (String)((Object)entry));
        }
        $this$forEach$iv = headers;
        $i$f$forEach = false;
        map2 = $this$forEach$iv;
        bl2 = false;
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$key$value = element$iv = iterator.next();
            boolean bl5 = false;
            value = $dstr$key$value;
            boolean bl6 = false;
            key = (String)value.getKey();
            entry = $dstr$key$value;
            bl = false;
            value = (String)entry.getValue();
            headersBuilder.add(key, (String)value);
        }
        return headersBuilder.build();
    }

    private final Map<String, String> toParams(RemoteExtensionQuery $this$toParams) {
        Object object = this.objectMapper.convertValue((Object)$this$toParams, (TypeReference)new TypeReference<Map<String, ? extends String>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026ap<String, String>>() {})");
        return (Map)object;
    }

    private static final Unit invoke$lambda-0(OkHttpRemoteExtensionTransport this$0, RemoteExtensionPayload $remoteExtensionPayload) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$remoteExtensionPayload, (String)"$remoteExtensionPayload");
        Request.Builder builder = new Request.Builder().url(this$0.url);
        Object object = this$0.httpConfig.getHeaders().getInvokeHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"httpConfig.headers.invokeHeaders");
        Request.Builder builder2 = builder.headers(this$0.buildHeaders((Map<String, String>)object));
        object = this$0.objectMapper.writeValueAsString((Object)$remoteExtensionPayload);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.writeValueA\u2026g(remoteExtensionPayload)");
        Request request = builder2.post(RequestBody.Companion.create((String)object, MediaType.Companion.get("application/json"))).build();
        Response response = this$0.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String string = responseBody == null ? null : responseBody.string();
            String reason = string == null ? "Unknown reason: " + response.code() : string;
            throw new OkHttpRemoteExtensionTransportException(reason);
        }
        return Unit.INSTANCE;
    }

    private static final RemoteExtensionResponse write$lambda-1(OkHttpRemoteExtensionTransport this$0, RemoteExtensionPayload $remoteExtensionPayload) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$remoteExtensionPayload, (String)"$remoteExtensionPayload");
        Request.Builder builder = new Request.Builder().url(this$0.url);
        Object object = this$0.httpConfig.getHeaders().getWriteHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"httpConfig.headers.writeHeaders");
        Request.Builder builder2 = builder.headers(this$0.buildHeaders((Map<String, String>)object));
        object = this$0.objectMapper.writeValueAsString((Object)$remoteExtensionPayload);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.writeValueA\u2026g(remoteExtensionPayload)");
        Request request = builder2.post(RequestBody.Companion.create((String)object, MediaType.Companion.get("application/json"))).build();
        Response response = this$0.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String string = responseBody == null ? null : responseBody.string();
            String reason = string == null ? "Unknown reason: " + response.code() : string;
            throw new OkHttpRemoteExtensionTransportException(reason);
        }
        ResponseBody responseBody = response.body();
        return (RemoteExtensionResponse)this$0.objectMapper.readValue(responseBody == null ? null : responseBody.string(), RemoteExtensionResponse.class);
    }

    private static final RemoteExtensionResponse read$lambda-2(OkHttpRemoteExtensionTransport this$0, RemoteExtensionQuery $remoteExtensionQuery) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$remoteExtensionQuery, (String)"$remoteExtensionQuery");
        Request.Builder builder = new Request.Builder().url(this$0.buildUrl(this$0.toParams($remoteExtensionQuery)));
        Map map = this$0.httpConfig.getHeaders().getReadHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"httpConfig.headers.readHeaders");
        Request request = builder.headers(this$0.buildHeaders(map)).get().build();
        Response response = this$0.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String string = responseBody == null ? null : responseBody.string();
            String reason = string == null ? "Unknown reason: " + response.code() : string;
            throw new OkHttpRemoteExtensionTransportException(reason);
        }
        ResponseBody responseBody = response.body();
        return (RemoteExtensionResponse)this$0.objectMapper.readValue(responseBody == null ? null : responseBody.string(), RemoteExtensionResponse.class);
    }
}

