/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.plugins.ClassKind;
import com.netflix.spinnaker.kork.plugins.DslKt;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager;
import com.netflix.spinnaker.kork.plugins.config.ConfigFactory;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginWrapper;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ!\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerExtensionFactory;", "Lorg/pf4j/ExtensionFactory;", "pluginManager", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "configFactory", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;", "pluginSdkFactories", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/SdkFactory;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;Ljava/util/List;)V", "create", "T", "extensionClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "kork-plugins"})
public final class SpinnakerExtensionFactory
implements ExtensionFactory {
    @NotNull
    private final SpinnakerPluginManager pluginManager;
    @NotNull
    private final ConfigFactory configFactory;
    @NotNull
    private final List<SdkFactory> pluginSdkFactories;

    public SpinnakerExtensionFactory(@NotNull SpinnakerPluginManager pluginManager, @NotNull ConfigFactory configFactory, @NotNull List<? extends SdkFactory> pluginSdkFactories) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginManager), (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)configFactory, (String)"configFactory");
        Intrinsics.checkNotNullParameter(pluginSdkFactories, (String)"pluginSdkFactories");
        this.pluginManager = pluginManager;
        this.configFactory = configFactory;
        this.pluginSdkFactories = pluginSdkFactories;
    }

    public <T> T create(@NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        PluginWrapper pluginWrapper = this.pluginManager.whichPlugin(extensionClass);
        return (T)DslKt.createWithConstructor(extensionClass, ClassKind.EXTENSION, this.pluginSdkFactories, this.configFactory, pluginWrapper);
    }
}

