/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.plugins.ClassKind;
import com.netflix.spinnaker.kork.plugins.DslKt;
import com.netflix.spinnaker.kork.plugins.config.ConfigFactory;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import java.lang.reflect.Modifier;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.Plugin;
import org.pf4j.PluginFactory;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginFactory;", "Lorg/pf4j/PluginFactory;", "pluginSdkFactories", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/SdkFactory;", "configFactory", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;", "(Ljava/util/List;Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "create", "Lorg/pf4j/Plugin;", "pluginWrapper", "Lorg/pf4j/PluginWrapper;", "isValidPlugin", "", "Ljava/lang/Class;", "kork-plugins"})
public final class SpinnakerPluginFactory
implements PluginFactory {
    @NotNull
    private final List<SdkFactory> pluginSdkFactories;
    @NotNull
    private final ConfigFactory configFactory;
    @NotNull
    private final Lazy log$delegate;

    public SpinnakerPluginFactory(@NotNull List<? extends SdkFactory> pluginSdkFactories, @NotNull ConfigFactory configFactory) {
        Intrinsics.checkNotNullParameter(pluginSdkFactories, (String)"pluginSdkFactories");
        Intrinsics.checkNotNullParameter((Object)configFactory, (String)"configFactory");
        this.pluginSdkFactories = pluginSdkFactories;
        this.configFactory = configFactory;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpinnakerPluginFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @Nullable
    public Plugin create(@NotNull PluginWrapper pluginWrapper) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)pluginWrapper, (String)"pluginWrapper");
        String pluginClassName = pluginWrapper.getDescriptor().getPluginClass();
        this.getLog().debug("Create instance for plugin '" + pluginClassName + "'");
        try {
            clazz = pluginWrapper.getPluginClassLoader().loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
        Class<?> pluginClass = clazz;
        Intrinsics.checkNotNullExpressionValue(pluginClass, (String)"pluginClass");
        if (!this.isValidPlugin(pluginClass)) {
            this.getLog().error("The plugin class '{}' is not valid", (Object)pluginClass.getCanonicalName());
            return null;
        }
        return (Plugin)DslKt.createWithConstructor(pluginClass, ClassKind.PLUGIN, this.pluginSdkFactories, this.configFactory, pluginWrapper);
    }

    private final boolean isValidPlugin(Class<?> $this$isValidPlugin) {
        int modifiers = $this$isValidPlugin.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers) && Plugin.class.isAssignableFrom($this$isValidPlugin);
    }
}

