/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.PluginStatusProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;", "Lorg/pf4j/PluginStatusProvider;", "Lorg/springframework/context/ApplicationListener;", "Lorg/springframework/boot/context/event/ApplicationEnvironmentPreparedEvent;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "rootConfig", "", "(Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "propertySource", "Lorg/springframework/core/env/MapPropertySource;", "propertySourceBackingStore", "", "", "disablePlugin", "", "pluginId", "enablePlugin", "enabledPropertyName", "isEnabled", "", "isPluginDisabled", "isPluginEnabled", "onApplicationEvent", "event", "pluginVersion", "versionPropertyName", "kork-plugins"})
public final class SpringPluginStatusProvider
implements PluginStatusProvider,
ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    @NotNull
    private final DynamicConfigService dynamicConfigService;
    @NotNull
    private final String rootConfig;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final Map<String, Object> propertySourceBackingStore;
    @NotNull
    private final MapPropertySource propertySource;

    public SpringPluginStatusProvider(@NotNull DynamicConfigService dynamicConfigService, @NotNull String rootConfig) {
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        Intrinsics.checkNotNullParameter((Object)rootConfig, (String)"rootConfig");
        this.dynamicConfigService = dynamicConfigService;
        this.rootConfig = rootConfig;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpringPluginStatusProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        boolean bl = false;
        this.propertySourceBackingStore = new LinkedHashMap();
        this.propertySource = new MapPropertySource("plugins", this.propertySourceBackingStore);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void disablePlugin(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.getLog().info("Disabling plugin: " + pluginId);
        Map<String, Object> map = this.propertySourceBackingStore;
        String string = this.enabledPropertyName(pluginId);
        Boolean bl = false;
        boolean bl2 = false;
        map.put(string, bl);
    }

    public boolean isPluginDisabled(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return !this.isEnabled(pluginId);
    }

    public final boolean isPluginEnabled(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return this.isEnabled(pluginId);
    }

    public void enablePlugin(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.getLog().info("Enabling plugin: " + pluginId);
        Map<String, Object> map = this.propertySourceBackingStore;
        String string = this.enabledPropertyName(pluginId);
        Boolean bl = true;
        boolean bl2 = false;
        map.put(string, bl);
    }

    public void onApplicationEvent(@NotNull ApplicationEnvironmentPreparedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getLog().debug("Adding " + this.getClass().getSimpleName() + " as new PropertySource");
        event.getEnvironment().getPropertySources().addFirst((PropertySource)this.propertySource);
    }

    private final boolean isEnabled(String pluginId) {
        return this.dynamicConfigService.isEnabled(this.enabledPropertyName(pluginId), false);
    }

    private final String enabledPropertyName(String pluginId) {
        return this.rootConfig + "." + pluginId;
    }

    @Nullable
    public final String pluginVersion(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return (String)this.dynamicConfigService.getConfig(String.class, this.versionPropertyName(pluginId), (Object)"unspecified");
    }

    private final String versionPropertyName(String pluginId) {
        return this.rootConfig + "." + pluginId + ".version";
    }
}

