/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.spinnaker.kork.plugins.api.yaml.YamlResourceLoader;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\u0003H\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/yaml/JacksonYamlResourceLoader;", "Lcom/netflix/spinnaker/kork/plugins/api/yaml/YamlResourceLoader;", "pluginClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "loadResource", "T", "resourceName", "", "toValueType", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "kork-plugins"})
public final class JacksonYamlResourceLoader
implements YamlResourceLoader {
    @NotNull
    private final Class<?> pluginClass;
    @NotNull
    private final ObjectMapper mapper;

    public JacksonYamlResourceLoader(@NotNull Class<?> pluginClass) {
        Intrinsics.checkNotNullParameter(pluginClass, (String)"pluginClass");
        this.pluginClass = pluginClass;
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"ObjectMapper(YAMLFactory\u2026IL_ON_UNKNOWN_PROPERTIES)");
        this.mapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T loadResource(@NotNull String resourceName, @NotNull Class<T> toValueType) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter(toValueType, (String)"toValueType");
        Closeable closeable = this.pluginClass.getClassLoader().getResourceAsStream(resourceName);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl3 = false;
            if (inputStream != null) {
                Object object = this.mapper.readValue(inputStream, toValueType);
                return (T)object;
            }
            try {
                throw new IllegalArgumentException("Cannot load specified resource '" + resourceName + "' for '" + this.pluginClass.getSimpleName() + "'");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

