/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.downloader;

import com.netflix.spinnaker.kork.plugins.update.downloader.SupportingFileDownloader;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.update.FileDownloader;
import org.pf4j.update.SimpleFileDownloader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/downloader/CompositeFileDownloader;", "Lorg/pf4j/update/FileDownloader;", "fileDownloaders", "", "Lcom/netflix/spinnaker/kork/plugins/update/downloader/SupportingFileDownloader;", "(Ljava/util/List;)V", "downloadFile", "Ljava/nio/file/Path;", "fileUrl", "Ljava/net/URL;", "kork-plugins"})
public final class CompositeFileDownloader
implements FileDownloader {
    @NotNull
    private final List<SupportingFileDownloader> fileDownloaders;

    public CompositeFileDownloader(@NotNull List<? extends SupportingFileDownloader> fileDownloaders) {
        Intrinsics.checkNotNullParameter(fileDownloaders, (String)"fileDownloaders");
        this.fileDownloaders = fileDownloaders;
    }

    @NotNull
    public Path downloadFile(@NotNull URL fileUrl) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            Iterable $this$firstOrNull$iv = this.fileDownloaders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SupportingFileDownloader it = (SupportingFileDownloader)element$iv;
                boolean bl = false;
                if (!it.supports(fileUrl)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        SupportingFileDownloader supportingFileDownloader = v0;
        Path path = (supportingFileDownloader == null ? (FileDownloader)new SimpleFileDownloader() : (FileDownloader)supportingFileDownloader).downloadFile(fileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fileDownloaders.firstOrN\u2026()).downloadFile(fileUrl)");
        return path;
    }
}

