/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.bundle;

import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.SpringStrictPluginLoaderStatusProvider;
import java.io.File;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0002R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/kork/plugins/bundle/PluginBundleExtractor;", "", "springStrictPluginLoaderStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringStrictPluginLoaderStatusProvider;", "(Lcom/netflix/spinnaker/kork/plugins/SpringStrictPluginLoaderStatusProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "extractBundle", "Ljava/nio/file/Path;", "bundlePath", "extractService", "service", "", "looksLikeBundle", "", "pluginPath", "kork-plugins"})
public final class PluginBundleExtractor {
    @NotNull
    private final SpringStrictPluginLoaderStatusProvider springStrictPluginLoaderStatusProvider;
    @NotNull
    private final Lazy log$delegate;

    public PluginBundleExtractor(@NotNull SpringStrictPluginLoaderStatusProvider springStrictPluginLoaderStatusProvider) {
        Intrinsics.checkNotNullParameter((Object)springStrictPluginLoaderStatusProvider, (String)"springStrictPluginLoaderStatusProvider");
        this.springStrictPluginLoaderStatusProvider = springStrictPluginLoaderStatusProvider;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ PluginBundleExtractor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Path extractBundle(@NotNull Path bundlePath) {
        Intrinsics.checkNotNullParameter((Object)bundlePath, (String)"bundlePath");
        Path path = FileUtils.expandIfZip((Path)bundlePath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"expandIfZip(bundlePath)");
        return path;
    }

    @Nullable
    public final Path extractService(@NotNull Path bundlePath, @NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)bundlePath, (String)"bundlePath");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Path extractedPath = this.extractBundle(bundlePath);
        if (!this.looksLikeBundle(extractedPath)) {
            this.getLog().debug("Plugin path does not appear to be a bundle, using as-is: {}", (Object)bundlePath);
            return extractedPath;
        }
        Path servicePluginZipPath = extractedPath.resolve(service + ".zip");
        if (servicePluginZipPath.toFile().exists()) {
            return FileUtils.expandIfZip((Path)servicePluginZipPath);
        }
        if (this.springStrictPluginLoaderStatusProvider.isStrictPluginLoading()) {
            throw new IntegrationException("Downloaded plugin bundle does not have plugin for service '" + service + "'");
        }
        this.getLog().warn("Downloaded plugin bundle '{}' does not have plugin for service: {}", (Object)bundlePath.getFileName(), (Object)service);
        return null;
    }

    private final boolean looksLikeBundle(Path pluginPath) {
        boolean bl;
        File[] fileArray = pluginPath.toFile().listFiles();
        if (fileArray == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            block3: {
                File[] $this$any$iv = fileArray;
                boolean $i$f$any = false;
                File[] fileArray2 = $this$any$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl4 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) continue;
                    bl3 = true;
                    break block3;
                }
                bl3 = false;
            }
            bl = bl2 = bl3;
        }
        return bl;
    }
}

