/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.github.zafarkhaja.semver.Version;
import com.netflix.spinnaker.kork.plugins.VersionRequirementsParser;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pf4j.VersionManager;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/kork/plugins/SpinnakerServiceVersionManager;", "Lorg/pf4j/VersionManager;", "serviceName", "", "(Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "checkVersionConstraint", "", "version", "requires", "compareVersions", "", "v1", "v2", "kork-plugins"})
public final class SpinnakerServiceVersionManager
implements VersionManager {
    @NotNull
    private final String serviceName;
    @NotNull
    private final Lazy log$delegate;

    public SpinnakerServiceVersionManager(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.serviceName = serviceName;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpinnakerServiceVersionManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        return (Logger)lazy.getValue();
    }

    public boolean checkVersionConstraint(@NotNull String version, @NotNull String requires) {
        Object v0;
        block3: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)requires, (String)"requires");
            CharSequence charSequence = requires;
            if (charSequence.length() == 0) {
                this.getLog().warn("Loading plugin with empty Plugin-Requires attribute!");
                return true;
            }
            Iterable iterable2 = iterable = (Iterable)VersionRequirementsParser.INSTANCE.parseAll(requires);
            boolean bl = false;
            for (Object t : iterable2) {
                VersionRequirementsParser.VersionRequirements it = (VersionRequirementsParser.VersionRequirements)t;
                boolean bl2 = false;
                if (!StringsKt.equals((String)it.getService(), (String)this.serviceName, (boolean)true)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        VersionRequirementsParser.VersionRequirements requirements = v0;
        if (requirements != null) {
            return StringUtils.isNullOrEmpty((String)requirements.getConstraint()) || Version.valueOf((String)version).satisfies(requirements.getConstraint());
        }
        return false;
    }

    public int compareVersions(@NotNull String v1, @NotNull String v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return Version.valueOf((String)v1).compareTo(Version.valueOf((String)v2));
    }
}

