/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.kork.plugins.VersionRequirementsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netflix/spinnaker/kork/plugins/VersionRequirementsParser;", "", "()V", "CONSTRAINT_VALIDATOR", "Lcom/github/zafarkhaja/semver/Version;", "kotlin.jvm.PlatformType", "SUPPORTS_PATTERN", "Ljava/util/regex/Pattern;", "SUPPORTS_PATTERN_CONSTRAINT_GROUP", "", "SUPPORTS_PATTERN_SERVICE_GROUP", "parse", "Lcom/netflix/spinnaker/kork/plugins/VersionRequirementsParser$VersionRequirements;", "version", "parseAll", "", "stringify", "requirements", "InvalidPluginVersionRequirementException", "VersionRequirements", "kork-plugins"})
public final class VersionRequirementsParser {
    @NotNull
    public static final VersionRequirementsParser INSTANCE = new VersionRequirementsParser();
    private static final Pattern SUPPORTS_PATTERN = Pattern.compile("^(?<service>[\\w\\-]+)(?<constraint>.*[><=]{1,2}[0-9]+\\.[0-9]+\\.[0-9]+.*)$");
    private static final Version CONSTRAINT_VALIDATOR = Version.valueOf((String)"0.0.0");
    @NotNull
    private static final String SUPPORTS_PATTERN_SERVICE_GROUP = "service";
    @NotNull
    private static final String SUPPORTS_PATTERN_CONSTRAINT_GROUP = "constraint";

    private VersionRequirementsParser() {
    }

    @NotNull
    public final VersionRequirements parse(@NotNull String version) {
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Matcher it = matcher = SUPPORTS_PATTERN.matcher(version);
        boolean bl = false;
        if (!it.matches()) {
            throw new InvalidPluginVersionRequirementException(version);
        }
        try {
            CONSTRAINT_VALIDATOR.satisfies(it.group(SUPPORTS_PATTERN_CONSTRAINT_GROUP));
        }
        catch (ParseException e) {
            throw new InvalidPluginVersionRequirementException(version);
        }
        it = matcher;
        boolean bl2 = false;
        String string = it.group(SUPPORTS_PATTERN_SERVICE_GROUP);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.group(SUPPORTS_PATTERN_SERVICE_GROUP)");
        String string2 = string;
        string = it.group(SUPPORTS_PATTERN_CONSTRAINT_GROUP);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.group(SUPPORTS_PATTERN_CONSTRAINT_GROUP)");
        return new VersionRequirements(string2, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VersionRequirements> parseAll(@NotNull String version) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        char[] cArray = new char[]{','};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)version, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            VersionRequirements versionRequirements = INSTANCE.parse(((Object)StringsKt.trim((CharSequence)((CharSequence)var11_11))).toString());
            collection.add(versionRequirements);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String stringify(@NotNull List<VersionRequirements> requirements) {
        Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
        return CollectionsKt.joinToString$default((Iterable)requirements, (CharSequence)",", null, null, (int)0, null, (Function1)stringify.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/kork/plugins/VersionRequirementsParser$VersionRequirements;", "", "service", "", "constraint", "(Ljava/lang/String;Ljava/lang/String;)V", "getConstraint", "()Ljava/lang/String;", "getService", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kork-plugins"})
    public static final class VersionRequirements {
        @NotNull
        private final String service;
        @NotNull
        private final String constraint;

        public VersionRequirements(@NotNull String service, @NotNull String constraint) {
            Intrinsics.checkNotNullParameter((Object)service, (String)VersionRequirementsParser.SUPPORTS_PATTERN_SERVICE_GROUP);
            Intrinsics.checkNotNullParameter((Object)constraint, (String)VersionRequirementsParser.SUPPORTS_PATTERN_CONSTRAINT_GROUP);
            this.service = service;
            this.constraint = constraint;
        }

        @NotNull
        public final String getService() {
            return this.service;
        }

        @NotNull
        public final String getConstraint() {
            return this.constraint;
        }

        @NotNull
        public String toString() {
            return this.service + this.constraint;
        }

        @NotNull
        public final String component1() {
            return this.service;
        }

        @NotNull
        public final String component2() {
            return this.constraint;
        }

        @NotNull
        public final VersionRequirements copy(@NotNull String service, @NotNull String constraint) {
            Intrinsics.checkNotNullParameter((Object)service, (String)VersionRequirementsParser.SUPPORTS_PATTERN_SERVICE_GROUP);
            Intrinsics.checkNotNullParameter((Object)constraint, (String)VersionRequirementsParser.SUPPORTS_PATTERN_CONSTRAINT_GROUP);
            return new VersionRequirements(service, constraint);
        }

        public static /* synthetic */ VersionRequirements copy$default(VersionRequirements versionRequirements, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = versionRequirements.service;
            }
            if ((n & 2) != 0) {
                string2 = versionRequirements.constraint;
            }
            return versionRequirements.copy(string, string2);
        }

        public int hashCode() {
            int result = this.service.hashCode();
            result = result * 31 + this.constraint.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionRequirements)) {
                return false;
            }
            VersionRequirements versionRequirements = (VersionRequirements)other;
            if (!Intrinsics.areEqual((Object)this.service, (Object)versionRequirements.service)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.constraint, (Object)versionRequirements.constraint);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/kork/plugins/VersionRequirementsParser$InvalidPluginVersionRequirementException;", "Lcom/netflix/spinnaker/kork/exceptions/UserException;", "version", "", "(Ljava/lang/String;)V", "kork-plugins"})
    public static final class InvalidPluginVersionRequirementException
    extends UserException {
        public InvalidPluginVersionRequirementException(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super("The provided version requirement '" + version + "' is not valid: It must conform a valid semantic version expression");
        }
    }
}

