/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.loaders;

import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.loaders.UnsafePluginClassLoader;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.DevelopmentPluginLoader;
import org.pf4j.PluginClassLoader;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/kork/plugins/loaders/SpinnakerDevelopmentPluginLoader;", "Lorg/pf4j/DevelopmentPluginLoader;", "pluginManager", "Lorg/pf4j/PluginManager;", "(Lorg/pf4j/PluginManager;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createPluginClassLoader", "Lorg/pf4j/PluginClassLoader;", "pluginPath", "Ljava/nio/file/Path;", "pluginDescriptor", "Lorg/pf4j/PluginDescriptor;", "kork-plugins"})
public final class SpinnakerDevelopmentPluginLoader
extends DevelopmentPluginLoader {
    @NotNull
    private final Lazy log$delegate;

    public SpinnakerDevelopmentPluginLoader(@NotNull PluginManager pluginManager) {
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        super(pluginManager);
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpinnakerDevelopmentPluginLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(((Object)((Object)this.this$0)).getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        return (Logger)lazy.getValue();
    }

    @NotNull
    protected PluginClassLoader createPluginClassLoader(@NotNull Path pluginPath, @NotNull PluginDescriptor pluginDescriptor) {
        PluginClassLoader pluginClassLoader;
        Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (!(pluginDescriptor instanceof SpinnakerPluginDescriptor)) {
            this.getLog().debug("Descriptor for " + pluginDescriptor.getPluginId() + " is not SpinnakerPluginDescriptor: Falling back to default behavior");
            PluginClassLoader pluginClassLoader2 = super.createPluginClassLoader(pluginPath, pluginDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)pluginClassLoader2, (String)"super.createPluginClassL\u2026inPath, pluginDescriptor)");
            return pluginClassLoader2;
        }
        if (((SpinnakerPluginDescriptor)pluginDescriptor).getUnsafe()) {
            Object object = this.pluginManager;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginManager");
            PluginManager pluginManager = object;
            SpinnakerPluginDescriptor spinnakerPluginDescriptor = (SpinnakerPluginDescriptor)pluginDescriptor;
            object = ((Object)((Object)this)).getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaClass.classLoader");
            pluginClassLoader = new UnsafePluginClassLoader(pluginManager, spinnakerPluginDescriptor, (ClassLoader)object);
        } else {
            PluginClassLoader pluginClassLoader3 = super.createPluginClassLoader(pluginPath, pluginDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)pluginClassLoader3, (String)"{\n      super.createPlug\u2026, pluginDescriptor)\n    }");
            pluginClassLoader = pluginClassLoader3;
        }
        return pluginClassLoader;
    }
}

