/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.proxy.aspects;

import com.netflix.spinnaker.kork.common.Header;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationState;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.LogInvocationState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J?\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J\u0016\u0010\"\u001a\u00020#2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006&"}, d2={"Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/LogInvocationAspect;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationAspect;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/LogInvocationState;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "after", "", "invocationState", "before", "target", "Lcom/netflix/spinnaker/kork/plugins/api/internal/SpinnakerExtensionPoint;", "proxy", "", "method", "Ljava/lang/reflect/Method;", "args", "", "descriptor", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;", "(Lcom/netflix/spinnaker/kork/plugins/api/internal/SpinnakerExtensionPoint;Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;)Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/LogInvocationState;", "error", "e", "Ljava/lang/reflect/InvocationTargetException;", "finally", "setOrRemoveMdc", "key", "", "value", "supports", "", "Ljava/lang/Class;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationState;", "kork-plugins"})
public final class LogInvocationAspect
implements InvocationAspect<LogInvocationState> {
    @NotNull
    private final Lazy log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
        final /* synthetic */ LogInvocationAspect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final Logger invoke() {
            return LoggerFactory.getLogger(this.this$0.getClass());
        }
    }));

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        return (Logger)lazy.getValue();
    }

    @Override
    public boolean supports(@NotNull Class<InvocationState> invocationState) {
        Intrinsics.checkNotNullParameter(invocationState, (String)"invocationState");
        return Intrinsics.areEqual(invocationState, LogInvocationState.class);
    }

    @Override
    @NotNull
    public LogInvocationState before(@NotNull SpinnakerExtensionPoint target, @NotNull Object proxy2, @NotNull Method method, @Nullable Object[] args, @NotNull SpinnakerPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)proxy2, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)descriptor), (String)"descriptor");
        String string = target.getClass().getSimpleName().toString();
        String string2 = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.name");
        LogInvocationState logInvocationState = new LogInvocationState(string, string2);
        string2 = Header.PLUGIN_ID.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PLUGIN_ID.header");
        this.setOrRemoveMdc(string2, descriptor.getPluginId());
        string2 = Header.PLUGIN_EXTENSION.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PLUGIN_EXTENSION.header");
        this.setOrRemoveMdc(string2, logInvocationState.getExtensionName$kork_plugins());
        this.getLog().trace("Invoking method={} on extension={}", (Object)logInvocationState.getMethodName$kork_plugins(), (Object)logInvocationState.getExtensionName$kork_plugins());
        return logInvocationState;
    }

    @Override
    public void after(@NotNull LogInvocationState invocationState) {
        Intrinsics.checkNotNullParameter((Object)invocationState, (String)"invocationState");
        this.getLog().trace("Successful execution of method={} on extension={}", (Object)invocationState.getExtensionName$kork_plugins(), (Object)invocationState.getMethodName$kork_plugins());
    }

    @Override
    public void error(@NotNull InvocationTargetException e, @NotNull LogInvocationState invocationState) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)invocationState, (String)"invocationState");
        Object[] objectArray = new Object[]{invocationState.getMethodName$kork_plugins(), invocationState.getExtensionName$kork_plugins(), e.getCause()};
        this.getLog().error("Error invoking method={} on extension={}", objectArray);
    }

    private final void setOrRemoveMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    @Override
    public void finally(@NotNull LogInvocationState invocationState) {
        Intrinsics.checkNotNullParameter((Object)invocationState, (String)"invocationState");
        MDC.remove((String)Header.PLUGIN_ID.getHeader());
        MDC.remove((String)Header.PLUGIN_EXTENSION.getHeader());
    }
}

