/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J'\u0010\u0014\u001a\u0004\u0018\u0001H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3Response;", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/Response;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "response", "Lokhttp3/Response;", "exception", "Ljava/lang/Exception;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lokhttp3/Response;Ljava/lang/Exception;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "responseBody", "Lokhttp3/ResponseBody;", "finalize", "", "getBody", "Ljava/io/InputStream;", "T", "", "expectedType", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getException", "Ljava/util/Optional;", "getHeaders", "", "", "getStatusCode", "", "kork-plugins"})
public final class Ok3Response
implements com.netflix.spinnaker.kork.plugins.api.httpclient.Response {
    @NotNull
    private final ObjectMapper objectMapper;
    @Nullable
    private final Response response;
    @Nullable
    private final Exception exception;
    @Nullable
    private final ResponseBody responseBody;
    @NotNull
    private final Lazy log$delegate;

    public Ok3Response(@NotNull ObjectMapper objectMapper, @Nullable Response response, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.objectMapper = objectMapper;
        this.response = response;
        this.exception = exception;
        Response response2 = this.response;
        this.responseBody = response2 == null ? null : response2.peekBody(Long.MAX_VALUE);
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Ok3Response this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputStream getBody() {
        InputStream inputStream;
        ResponseBody responseBody = this.responseBody;
        if (responseBody == null) {
            inputStream = null;
        } else {
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                InputStream inputStream2 = it.byteStream();
                inputStream = inputStream2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getBody(@NotNull Class<T> expectedType) {
        String string;
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        ResponseBody responseBody = this.responseBody;
        if (responseBody == null) {
            string = null;
        } else {
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                String string2 = it.string();
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        String string3 = string;
        if (string3 == null) {
            return null;
        }
        String body = string3;
        return (T)this.objectMapper.readValue(body, expectedType);
    }

    @NotNull
    public Optional<Exception> getException() {
        Optional<Exception> optional = Optional.ofNullable(this.exception);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(exception)");
        return optional;
    }

    public int getStatusCode() {
        int n;
        Response response = this.response;
        return response == null ? -1 : (n = response.code());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, String> getHeaders() {
        Map map;
        Response response = this.response;
        if (response == null) {
            map = null;
        } else {
            Headers headers = response.headers();
            if (headers == null) {
                map = null;
            } else {
                Map map2 = headers.toMultimap();
                if (map2 == null) {
                    map = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Map map3 = map2;
                    boolean $i$f$map = false;
                    void var8_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it;
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Pair pair = TuplesKt.to(it.getKey(), (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)it.getValue()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                        collection.add(pair);
                    }
                    List list = (List)destination$iv$iv;
                    map = MapsKt.toMap((Iterable)list);
                }
            }
        }
        Map map4 = map;
        return map4 == null ? MapsKt.emptyMap() : map4;
    }

    public final void finalize() {
        try {
            ResponseBody responseBody;
            Response response = this.response;
            if (response != null && (responseBody = response.body()) != null) {
                responseBody.close();
            }
            if ((response = this.responseBody) != null) {
                response.close();
            }
        }
        catch (Exception e) {
            this.getLog().warn("Failed to cleanup resource", (Throwable)e);
        }
    }
}

