/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.release.provider;

import com.netflix.spinnaker.kork.plugins.SpringStrictPluginLoaderStatusProvider;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.provider.PluginInfoReleaseProvider;
import com.netflix.spinnaker.kork.plugins.update.release.provider.PluginReleaseNotFoundException;
import com.netflix.spinnaker.kork.plugins.update.release.source.PluginInfoReleaseSource;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.update.PluginInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003H\u0016J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0010H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/release/provider/AggregatePluginInfoReleaseProvider;", "Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;", "pluginInfoReleaseSources", "", "Lcom/netflix/spinnaker/kork/plugins/update/release/source/PluginInfoReleaseSource;", "strictPluginLoaderStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringStrictPluginLoaderStatusProvider;", "(Ljava/util/List;Lcom/netflix/spinnaker/kork/plugins/SpringStrictPluginLoaderStatusProvider;)V", "getReleases", "", "Lcom/netflix/spinnaker/kork/plugins/update/release/PluginInfoRelease;", "pluginInfo", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo;", "missingPluginWithStrictLoading", "", "pluginInfoReleases", "Lorg/pf4j/update/PluginInfo;", "kork-plugins"})
public final class AggregatePluginInfoReleaseProvider
implements PluginInfoReleaseProvider {
    @NotNull
    private final List<PluginInfoReleaseSource> pluginInfoReleaseSources;
    @NotNull
    private final SpringStrictPluginLoaderStatusProvider strictPluginLoaderStatusProvider;

    public AggregatePluginInfoReleaseProvider(@NotNull List<? extends PluginInfoReleaseSource> pluginInfoReleaseSources, @NotNull SpringStrictPluginLoaderStatusProvider strictPluginLoaderStatusProvider) {
        Intrinsics.checkNotNullParameter(pluginInfoReleaseSources, (String)"pluginInfoReleaseSources");
        Intrinsics.checkNotNullParameter((Object)strictPluginLoaderStatusProvider, (String)"strictPluginLoaderStatusProvider");
        this.pluginInfoReleaseSources = pluginInfoReleaseSources;
        this.strictPluginLoaderStatusProvider = strictPluginLoaderStatusProvider;
    }

    @Override
    @NotNull
    public Set<PluginInfoRelease> getReleases(@NotNull List<SpinnakerPluginInfo> pluginInfo) {
        Intrinsics.checkNotNullParameter(pluginInfo, (String)"pluginInfo");
        Set pluginInfoReleases = new LinkedHashSet();
        Iterable $this$forEach$iv = this.pluginInfoReleaseSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginInfoReleaseSource source = (PluginInfoReleaseSource)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = source.getReleases(pluginInfo);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object v0;
                PluginInfoRelease release;
                block5: {
                    release = (PluginInfoRelease)element$iv2;
                    boolean bl2 = false;
                    Iterable iterable = pluginInfoReleases;
                    for (Object t : iterable) {
                        PluginInfoRelease it = (PluginInfoRelease)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)release.getPluginId())) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                PluginInfoRelease hit = v0;
                if (hit != null) {
                    pluginInfoReleases.remove(hit);
                    pluginInfoReleases.add(release);
                    continue;
                }
                pluginInfoReleases.add(release);
            }
            source.processReleases(pluginInfoReleases);
        }
        $this$forEach$iv = pluginInfo;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpinnakerPluginInfo plugin = (SpinnakerPluginInfo)((Object)element$iv);
            boolean bl = false;
            if (!this.missingPluginWithStrictLoading(pluginInfoReleases, plugin)) continue;
            String string = plugin.id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.id");
            throw new PluginReleaseNotFoundException(string, this.pluginInfoReleaseSources);
        }
        return pluginInfoReleases;
    }

    private final boolean missingPluginWithStrictLoading(Set<PluginInfoRelease> pluginInfoReleases, PluginInfo pluginInfo) {
        Object v0;
        block1: {
            Iterable iterable = pluginInfoReleases;
            for (Object t : iterable) {
                PluginInfoRelease it = (PluginInfoRelease)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)pluginInfo.id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 == null && this.strictPluginLoaderStatusProvider.isStrictPluginLoading();
    }
}

