/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.loaders;

import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.loaders.UnsafePluginClassLoader;
import com.netflix.spinnaker.kork.plugins.pluginref.PluginRef;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.BasePluginLoader;
import org.pf4j.PluginClasspath;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/kork/plugins/loaders/PluginRefPluginLoader;", "Lorg/pf4j/PluginLoader;", "pluginManager", "Lorg/pf4j/PluginManager;", "(Lorg/pf4j/PluginManager;)V", "isApplicable", "", "pluginPath", "Ljava/nio/file/Path;", "loadPlugin", "Ljava/lang/ClassLoader;", "pluginDescriptor", "Lorg/pf4j/PluginDescriptor;", "kork-plugins"})
public final class PluginRefPluginLoader
implements PluginLoader {
    @NotNull
    private final PluginManager pluginManager;

    public PluginRefPluginLoader(@NotNull PluginManager pluginManager) {
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        this.pluginManager = pluginManager;
    }

    @NotNull
    public ClassLoader loadPlugin(@Nullable Path pluginPath, @Nullable PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor instanceof SpinnakerPluginDescriptor && ((SpinnakerPluginDescriptor)pluginDescriptor).getUnsafe()) {
            SpinnakerPluginDescriptor spinnakerPluginDescriptor = (SpinnakerPluginDescriptor)pluginDescriptor;
            ClassLoader classLoader = this.getClass().getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"javaClass.classLoader");
            return (ClassLoader)((Object)new UnsafePluginClassLoader(this.pluginManager, spinnakerPluginDescriptor, classLoader));
        }
        PluginRef ref = PluginRef.Companion.loadPluginRef(pluginPath);
        PluginClasspath cp = new PluginClasspath();
        cp.addClassesDirectories((Collection)ref.getClassesDirs());
        cp.addJarsDirectories((Collection)ref.getLibsDirs());
        ClassLoader classLoader = new BasePluginLoader(this.pluginManager, cp).loadPlugin(ref.getRefPath(), pluginDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"BasePluginLoader(pluginM\u2026efPath, pluginDescriptor)");
        return classLoader;
    }

    public boolean isApplicable(@Nullable Path pluginPath) {
        return PluginRef.Companion.isPluginRef(pluginPath);
    }
}

