/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.config.OkHttpMetricsInterceptorProperties;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.HttpClientSdkFactory;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.OkHttp3ClientFactory;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal.CompositeOkHttpClientFactory;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.internal.DefaultOkHttp3ClientFactory;
import com.netflix.spinnaker.okhttp.OkHttp3MetricsInterceptor;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class HttpClientSdkConfiguration {
    @Bean
    public static SdkFactory httpClientSdkFactory(List<OkHttp3ClientFactory> okHttpClientFactories, Environment environment, Provider<Registry> registry) {
        OkHttpClientConfigurationProperties okHttpClientProperties = (OkHttpClientConfigurationProperties)Binder.get((Environment)environment).bind("ok-http-client", Bindable.of(OkHttpClientConfigurationProperties.class)).orElse((Object)new OkHttpClientConfigurationProperties());
        OkHttpMetricsInterceptorProperties okHttpMetricsInterceptorProperties = (OkHttpMetricsInterceptorProperties)Binder.get((Environment)environment).bind("ok-http-client.interceptor", Bindable.of(OkHttpMetricsInterceptorProperties.class)).orElse((Object)new OkHttpMetricsInterceptorProperties());
        ArrayList<OkHttp3ClientFactory> factories = new ArrayList<OkHttp3ClientFactory>(okHttpClientFactories);
        OkHttp3MetricsInterceptor okHttp3MetricsInterceptor = new OkHttp3MetricsInterceptor(registry, okHttpMetricsInterceptorProperties);
        factories.add(new DefaultOkHttp3ClientFactory(okHttp3MetricsInterceptor));
        OkHttp3ClientConfiguration config = new OkHttp3ClientConfiguration(okHttpClientProperties, okHttp3MetricsInterceptor);
        KotlinModule kotlinModule = new KotlinModule.Builder().build();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)kotlinModule);
        objectMapper.disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        objectMapper.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return new HttpClientSdkFactory(new CompositeOkHttpClientFactory(factories), environment, objectMapper, config);
    }
}

