/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.config;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.config.ConfigCoordinates;
import com.netflix.spinnaker.kork.plugins.config.ConfigResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000fH\u0002J)\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J=\u0010\u0019\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002H\u00110\u001dH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u00010\"0\u000f*\u0006\u0012\u0002\b\u00030#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/netflix/spinnaker/kork/plugins/config/SpringEnvironmentConfigResolver;", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigResolver;", "environment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "(Lorg/springframework/core/env/ConfigurableEnvironment;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "propertySourcesAsMap", "", "resolve", "T", "coordinates", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigCoordinates;", "expectedType", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Lcom/netflix/spinnaker/kork/plugins/config/ConfigCoordinates;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "Ljava/lang/Class;", "(Lcom/netflix/spinnaker/kork/plugins/config/ConfigCoordinates;Ljava/lang/Class;)Ljava/lang/Object;", "resolveInternal", "missingCallback", "Lkotlin/Function0;", "callback", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/node/TreeTraversingParser;", "(Lcom/netflix/spinnaker/kork/plugins/config/ConfigCoordinates;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toRelevantProperties", "", "", "Lorg/springframework/core/env/EnumerablePropertySource;", "SystemConfigException", "kork-plugins"})
@Beta
public final class SpringEnvironmentConfigResolver
implements ConfigResolver {
    @NotNull
    private final ConfigurableEnvironment environment;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final ObjectMapper mapper;

    public SpringEnvironmentConfigResolver(@NotNull ConfigurableEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpringEnvironmentConfigResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"ObjectMapper()\n    .disa\u2026ture.FAIL_ON_EMPTY_BEANS)");
        this.mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @Override
    public <T> T resolve(@NotNull ConfigCoordinates coordinates, @NotNull Class<T> expectedType) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        return this.resolveInternal(coordinates, (Function0)new Function0<T>(this, expectedType){
            final /* synthetic */ SpringEnvironmentConfigResolver this$0;
            final /* synthetic */ Class<T> $expectedType;
            {
                this.this$0 = $receiver;
                this.$expectedType = $expectedType;
                super(0);
            }

            public final T invoke() {
                return (T)SpringEnvironmentConfigResolver.access$getMapper$p(this.this$0).convertValue((Object)MapsKt.emptyMap(), this.$expectedType);
            }
        }, (Function1)new Function1<TreeTraversingParser, T>(this, expectedType){
            final /* synthetic */ SpringEnvironmentConfigResolver this$0;
            final /* synthetic */ Class<T> $expectedType;
            {
                this.this$0 = $receiver;
                this.$expectedType = $expectedType;
                super(1);
            }

            public final T invoke(@NotNull TreeTraversingParser it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)SpringEnvironmentConfigResolver.access$getMapper$p(this.this$0).readValue((JsonParser)it, this.$expectedType);
            }
        });
    }

    @Override
    public <T> T resolve(@NotNull ConfigCoordinates coordinates, @NotNull TypeReference<T> expectedType) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        return this.resolveInternal(coordinates, (Function0)new Function0<T>(expectedType, this){
            final /* synthetic */ TypeReference<T> $expectedType;
            final /* synthetic */ SpringEnvironmentConfigResolver this$0;
            {
                this.$expectedType = $expectedType;
                this.this$0 = $receiver;
                super(0);
            }

            public final T invoke() {
                Type type = this.$expectedType.getType();
                if (type == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
                }
                Type type2 = ((ParameterizedType)type).getRawType();
                if (type2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<T of com.netflix.spinnaker.kork.plugins.config.SpringEnvironmentConfigResolver.resolve>");
                }
                Class type3 = (Class)type2;
                if (type3.isInterface()) {
                    throw this.this$0.new SystemConfigException("Expected type must be a concrete class, interface given");
                }
                return (T)SpringEnvironmentConfigResolver.access$getMapper$p(this.this$0).convertValue((Object)MapsKt.emptyMap(), type3);
            }
        }, (Function1)new Function1<TreeTraversingParser, T>(this, expectedType){
            final /* synthetic */ SpringEnvironmentConfigResolver this$0;
            final /* synthetic */ TypeReference<T> $expectedType;
            {
                this.this$0 = $receiver;
                this.$expectedType = $expectedType;
                super(1);
            }

            public final T invoke(@NotNull TreeTraversingParser it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)SpringEnvironmentConfigResolver.access$getMapper$p(this.this$0).readValue((JsonParser)it, this.$expectedType);
            }
        });
    }

    private final <T> T resolveInternal(ConfigCoordinates coordinates, Function0<? extends T> missingCallback, Function1<? super TreeTraversingParser, ? extends T> callback) {
        String pointer = coordinates.toPointer();
        this.getLog().debug("Searching for config at '" + pointer + "'");
        JsonNode tree = ((ObjectNode)this.mapper.valueToTree(this.propertySourcesAsMap())).at(pointer);
        if (tree instanceof MissingNode) {
            this.getLog().debug("Missing configuration for '" + coordinates + "': Loading default");
            return (T)missingCallback.invoke();
        }
        this.getLog().debug("Found config at '" + pointer + "'");
        try {
            return (T)callback.invoke((Object)new TreeTraversingParser(tree, (ObjectCodec)this.mapper));
        }
        catch (JsonParseException pe) {
            throw new IntegrationException("Failed reading extension config: Input appears invalid", (Throwable)pe);
        }
        catch (JsonMappingException me) {
            throw new IntegrationException("Failed reading extension config: Could not map provided config to expected shape", (Throwable)me);
        }
        catch (RuntimeException e) {
            throw new SystemException("Failed resolving extension config for an unexpected reason", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<?, ?> propertySourcesAsMap() {
        Properties properties;
        void $this$fold$iv;
        void $this$filterIsInstanceTo$iv$iv;
        MutablePropertySources mutablePropertySources = this.environment.getPropertySources();
        Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"environment.propertySources");
        Iterable $this$filterIsInstance$iv = CollectionsKt.reversed((Iterable)((Iterable)mutablePropertySources));
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EnumerablePropertySource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        Map initial$iv = new LinkedHashMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void ps;
            Object element$iv$iv;
            element$iv$iv = (EnumerablePropertySource)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            acc.putAll(this.toRelevantProperties((EnumerablePropertySource<?>)ps));
            accumulator$iv = acc;
        }
        Map it = accumulator$iv;
        boolean bl = false;
        Properties $this$propertySourcesAsMap_u24lambda_u2d2_u24lambda_u2d1 = properties = new Properties();
        boolean bl2 = false;
        $this$propertySourcesAsMap_u24lambda_u2d2_u24lambda_u2d1.putAll((Map<?, ?>)it);
        it = properties;
        boolean bl3 = false;
        Map map = (Map)new JavaPropsMapper().readPropertiesAs((Properties)it, Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"environment.propertySour\u2026As(it, Map::class.java) }");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toRelevantProperties(EnumerablePropertySource<?> $this$toRelevantProperties) {
        Object $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray = $this$toRelevantProperties.getPropertyNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"propertyNames");
        Object $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (String element$iv$iv : $this$filterTo$iv$iv) {
            String it = element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!StringsKt.startsWith$default((String)it, (String)"spinnaker.extensibility", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            String element$iv$iv;
            element$iv$iv = (String)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)$this$toRelevantProperties.getProperty((String)it)));
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            Pair pair = (Pair)t;
            boolean bl = false;
            Object value = pair.component2();
            boolean bl2 = value instanceof Map ? !((Map)value).isEmpty() : true;
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$p(SpringEnvironmentConfigResolver $this) {
        return $this.mapper;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/kork/plugins/config/SpringEnvironmentConfigResolver$SystemConfigException;", "Lcom/netflix/spinnaker/kork/exceptions/SystemException;", "message", "", "(Lcom/netflix/spinnaker/kork/plugins/config/SpringEnvironmentConfigResolver;Ljava/lang/String;)V", "kork-plugins"})
    private final class SystemConfigException
    extends SystemException {
        public SystemConfigException(String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

