/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.remote;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.spinnaker.kork.plugins.events.RemotePluginCacheRefresh;
import com.netflix.spinnaker.kork.plugins.remote.RemotePlugin;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/kork/plugins/remote/RemotePluginsCache;", "", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/springframework/context/ApplicationEventPublisher;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/netflix/spinnaker/kork/plugins/remote/RemotePlugin;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "get", "pluginId", "get$kork_plugins", "getAll", "", "getAll$kork_plugins", "put", "", "remotePlugin", "put$kork_plugins", "remove", "remove$kork_plugins", "kork-plugins"})
public final class RemotePluginsCache {
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final Cache<String, RemotePlugin> cache;

    public RemotePluginsCache(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.applicationEventPublisher = applicationEventPublisher;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ RemotePluginsCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        Cache cache = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder()\n    .build<String, RemotePlugin>()");
        this.cache = cache;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @Nullable
    public final RemotePlugin get$kork_plugins(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return (RemotePlugin)this.cache.getIfPresent((Object)pluginId);
    }

    @NotNull
    public final Map<String, RemotePlugin> getAll$kork_plugins() {
        ConcurrentMap concurrentMap = this.cache.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"cache.asMap()");
        return concurrentMap;
    }

    public final void put$kork_plugins(@NotNull RemotePlugin remotePlugin) {
        Intrinsics.checkNotNullParameter((Object)remotePlugin, (String)"remotePlugin");
        this.cache.put((Object)remotePlugin.getId(), (Object)remotePlugin);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RemotePluginCacheRefresh(this, remotePlugin.getId()));
        this.getLog().debug("Put remote plugin '{}'.", (Object)remotePlugin.getId());
    }

    public final void remove$kork_plugins(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.cache.invalidate((Object)pluginId);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RemotePluginCacheRefresh(this, pluginId));
        this.getLog().debug("Removed remote plugin '{}'.", (Object)pluginId);
    }
}

