/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk;

import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.plugins.api.PluginSdks;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientRegistry;
import com.netflix.spinnaker.kork.plugins.api.serde.SerdeService;
import com.netflix.spinnaker.kork.plugins.api.servicesdk.ServiceSdk;
import com.netflix.spinnaker.kork.plugins.api.yaml.YamlResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/PluginSdksImpl;", "Lcom/netflix/spinnaker/kork/plugins/api/PluginSdks;", "sdkServices", "", "", "(Ljava/util/List;)V", "http", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientRegistry;", "serde", "Lcom/netflix/spinnaker/kork/plugins/api/serde/SerdeService;", "service", "T", "serviceClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "serviceSdk", "Lcom/netflix/spinnaker/kork/plugins/api/servicesdk/ServiceSdk;", "type", "(Ljava/lang/Class;)Lcom/netflix/spinnaker/kork/plugins/api/servicesdk/ServiceSdk;", "yamlResourceLoader", "Lcom/netflix/spinnaker/kork/plugins/api/yaml/YamlResourceLoader;", "kork-plugins"})
public final class PluginSdksImpl
implements PluginSdks {
    @NotNull
    private final List<Object> sdkServices;

    public PluginSdksImpl(@NotNull List<? extends Object> sdkServices) {
        Intrinsics.checkNotNullParameter(sdkServices, (String)"sdkServices");
        this.sdkServices = sdkServices;
    }

    @NotNull
    public HttpClientRegistry http() {
        return this.service(HttpClientRegistry.class);
    }

    @NotNull
    public YamlResourceLoader yamlResourceLoader() {
        return this.service(YamlResourceLoader.class);
    }

    @NotNull
    public SerdeService serde() {
        return this.service(SerdeService.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends ServiceSdk> T serviceSdk(@NotNull Class<T> type) {
        ServiceSdk it;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Iterable $this$filterIsInstance$iv = this.sdkServices;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ServiceSdk)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ServiceSdk serviceSdk = (ServiceSdk)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (serviceSdk != null) {
            it = serviceSdk;
            boolean bl = false;
            if (!type.isAssignableFrom(it.getClass())) {
                throw new IntegrationException("Requested unknown serivce SDK type, but '" + it.getClass().getSimpleName() + "' is available");
            }
        } else {
            throw new SystemException("No service SDK is configured for this service");
        }
        return (T)it;
    }

    private final <T> T service(Class<T> serviceClass) {
        Object object = CollectionsKt.firstOrNull((List)CollectionsKt.filterIsInstance((Iterable)this.sdkServices, serviceClass));
        if (object == null) {
            throw new SystemException(serviceClass + " is not configured");
        }
        return (T)object;
    }
}

