/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.DefaultServiceEndpoint;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.api.plugins.remote.RemoteExtensionConfig;
import com.netflix.spinnaker.kork.jackson.ObjectMapperSubtypeConfigurer;
import com.netflix.spinnaker.kork.plugins.events.RemotePluginConfigChanged;
import com.netflix.spinnaker.kork.plugins.remote.RemoteExtensionDefinitionNotFound;
import com.netflix.spinnaker.kork.plugins.remote.RemoteExtensionTransportConfigurationException;
import com.netflix.spinnaker.kork.plugins.remote.RemotePlugin;
import com.netflix.spinnaker.kork.plugins.remote.RemotePluginsCache;
import com.netflix.spinnaker.kork.plugins.remote.extension.RemoteExtension;
import com.netflix.spinnaker.kork.plugins.remote.extension.RemoteExtensionPointConfig;
import com.netflix.spinnaker.kork.plugins.remote.extension.RemoteExtensionPointDefinition;
import com.netflix.spinnaker.kork.plugins.remote.extension.transport.http.OkHttpRemoteExtensionTransport;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationListener;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BK\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002R#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/spinnaker/kork/plugins/remote/RemotePluginConfigChangedListener;", "Lorg/springframework/context/ApplicationListener;", "Lcom/netflix/spinnaker/kork/plugins/events/RemotePluginConfigChanged;", "objectMapperProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "subtypeLocatorsProvider", "", "Lcom/netflix/spinnaker/kork/jackson/ObjectMapperSubtypeConfigurer$SubtypeLocator;", "okHttpClientProvider", "Lcom/netflix/spinnaker/config/okhttp3/OkHttpClientProvider;", "remotePluginsCache", "Lcom/netflix/spinnaker/kork/plugins/remote/RemotePluginsCache;", "remoteExtensionPointDefinitions", "Lcom/netflix/spinnaker/kork/plugins/remote/extension/RemoteExtensionPointDefinition;", "(Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/ObjectProvider;Lorg/springframework/beans/factory/ObjectProvider;Lcom/netflix/spinnaker/kork/plugins/remote/RemotePluginsCache;Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "onApplicationEvent", "", "event", "put", "kork-plugins"})
@Beta
public final class RemotePluginConfigChangedListener
implements ApplicationListener<RemotePluginConfigChanged> {
    @NotNull
    private final ObjectProvider<ObjectMapper> objectMapperProvider;
    @NotNull
    private final ObjectProvider<OkHttpClientProvider> okHttpClientProvider;
    @NotNull
    private final RemotePluginsCache remotePluginsCache;
    @NotNull
    private final List<RemoteExtensionPointDefinition> remoteExtensionPointDefinitions;
    @NotNull
    private final Lazy log$delegate;

    public RemotePluginConfigChangedListener(@NotNull ObjectProvider<ObjectMapper> objectMapperProvider, @NotNull ObjectProvider<List<ObjectMapperSubtypeConfigurer.SubtypeLocator>> subtypeLocatorsProvider, @NotNull ObjectProvider<OkHttpClientProvider> okHttpClientProvider, @NotNull RemotePluginsCache remotePluginsCache, @NotNull List<? extends RemoteExtensionPointDefinition> remoteExtensionPointDefinitions) {
        Intrinsics.checkNotNullParameter(objectMapperProvider, (String)"objectMapperProvider");
        Intrinsics.checkNotNullParameter(subtypeLocatorsProvider, (String)"subtypeLocatorsProvider");
        Intrinsics.checkNotNullParameter(okHttpClientProvider, (String)"okHttpClientProvider");
        Intrinsics.checkNotNullParameter((Object)remotePluginsCache, (String)"remotePluginsCache");
        Intrinsics.checkNotNullParameter(remoteExtensionPointDefinitions, (String)"remoteExtensionPointDefinitions");
        this.objectMapperProvider = objectMapperProvider;
        this.okHttpClientProvider = okHttpClientProvider;
        this.remotePluginsCache = remotePluginsCache;
        this.remoteExtensionPointDefinitions = remoteExtensionPointDefinitions;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ RemotePluginConfigChangedListener this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        Collection collection = (Collection)subtypeLocatorsProvider.getIfAvailable();
        if (!(collection == null || collection.isEmpty())) {
            new ObjectMapperSubtypeConfigurer(true).registerSubtypes((ObjectMapper)this.objectMapperProvider.getObject(), (List)subtypeLocatorsProvider.getIfAvailable());
        }
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public void onApplicationEvent(@NotNull RemotePluginConfigChanged event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        switch (WhenMappings.$EnumSwitchMapping$0[event.getStatus().ordinal()]) {
            case 1: {
                this.put(event);
                break;
            }
            case 2: {
                this.put(event);
                break;
            }
            case 3: {
                this.remotePluginsCache.remove$kork_plugins(event.getPluginId());
            }
        }
    }

    private final void put(RemotePluginConfigChanged event) {
        Set remoteExtensions = new LinkedHashSet();
        Iterable $this$forEach$iv = event.getRemoteExtensionConfigs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RemoteExtensionPointDefinition remoteExtensionDefinition;
            Object v4;
            OkHttpRemoteExtensionTransport remoteExtensionTransport;
            RemoteExtensionConfig remoteExtensionConfig;
            block4: {
                remoteExtensionConfig = (RemoteExtensionConfig)element$iv;
                boolean bl = false;
                String string = remoteExtensionConfig.getTransport().getHttp().getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remoteExtensionConfig.transport.http.url");
                if (!(((CharSequence)string).length() > 0)) {
                    throw new RemoteExtensionTransportConfigurationException(event.getPluginId());
                }
                OkHttpClient client = ((OkHttpClientProvider)this.okHttpClientProvider.getObject()).getClient((ServiceEndpoint)new DefaultServiceEndpoint(remoteExtensionConfig.getId(), remoteExtensionConfig.getTransport().getHttp().getUrl(), remoteExtensionConfig.getTransport().getHttp().getConfig()));
                Object object = this.objectMapperProvider.getObject();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapperProvider.getObject()");
                ObjectMapper objectMapper = (ObjectMapper)object;
                Intrinsics.checkNotNullExpressionValue((Object)client, (String)"client");
                RemoteExtensionConfig.RemoteExtensionTransportConfig.Http http = remoteExtensionConfig.getTransport().getHttp();
                Intrinsics.checkNotNullExpressionValue((Object)http, (String)"remoteExtensionConfig.transport.http");
                remoteExtensionTransport = new OkHttpRemoteExtensionTransport(objectMapper, client, http);
                Iterable iterable = this.remoteExtensionPointDefinitions;
                for (Object t : iterable) {
                    RemoteExtensionPointDefinition it = (RemoteExtensionPointDefinition)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.type(), (Object)remoteExtensionConfig.getType())) continue;
                    v4 = t;
                    break block4;
                }
                v4 = null;
            }
            if ((RemoteExtensionPointDefinition)v4 == null) {
                String string = remoteExtensionConfig.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remoteExtensionConfig.type");
                throw new RemoteExtensionDefinitionNotFound(string);
            }
            Class<? extends RemoteExtensionPointConfig> configType = remoteExtensionDefinition.configType();
            String string = remoteExtensionConfig.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remoteExtensionConfig.id");
            String string2 = event.getPluginId();
            String string3 = remoteExtensionDefinition.type();
            Object object = ((ObjectMapper)this.objectMapperProvider.getObject()).convertValue((Object)remoteExtensionConfig.getConfig(), configType);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapperProvider.get\u2026onfig.config, configType)");
            remoteExtensions.add(new RemoteExtension(string, string2, string3, (RemoteExtensionPointConfig)object, remoteExtensionTransport));
        }
        RemotePlugin remotePlugin = new RemotePlugin(event.getPluginId(), event.getVersion(), remoteExtensions);
        this.remotePluginsCache.put$kork_plugins(remotePlugin);
        this.getLog().debug("Remote plugin '{}' added to cache due to '{}' event", (Object)event.getPluginId(), (Object)event.getStatus());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RemotePluginConfigChanged.Status.values().length];
            nArray[RemotePluginConfigChanged.Status.ENABLED.ordinal()] = 1;
            nArray[RemotePluginConfigChanged.Status.UPDATED.ordinal()] = 2;
            nArray[RemotePluginConfigChanged.Status.DISABLED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

