/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.release.remote;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager;
import com.netflix.spinnaker.kork.plugins.SpringPluginStatusProvider;
import com.netflix.spinnaker.kork.plugins.events.RemotePluginConfigChanged;
import com.netflix.spinnaker.kork.plugins.update.SpinnakerUpdateManager;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.provider.PluginInfoReleaseProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0007J\u0016\u0010\u001f\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/release/remote/RemotePluginInfoReleaseCache;", "", "pluginInfoReleaseProvider", "Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "updateManager", "Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;", "pluginManager", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "springPluginStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;", "(Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;Lorg/springframework/context/ApplicationEventPublisher;Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "pluginCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/netflix/spinnaker/kork/plugins/update/release/PluginInfoRelease;", "addOrUpdate", "", "enabledPlugins", "", "get", "pluginId", "refresh", "remove", "versionConstraint", "", "requires", "kork-plugins"})
@Beta
public final class RemotePluginInfoReleaseCache {
    @NotNull
    private final PluginInfoReleaseProvider pluginInfoReleaseProvider;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final SpinnakerUpdateManager updateManager;
    @NotNull
    private final SpinnakerPluginManager pluginManager;
    @NotNull
    private final SpringPluginStatusProvider springPluginStatusProvider;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final Cache<String, PluginInfoRelease> pluginCache;

    public RemotePluginInfoReleaseCache(@NotNull PluginInfoReleaseProvider pluginInfoReleaseProvider, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull SpinnakerUpdateManager updateManager, @NotNull SpinnakerPluginManager pluginManager, @NotNull SpringPluginStatusProvider springPluginStatusProvider) {
        Intrinsics.checkNotNullParameter((Object)pluginInfoReleaseProvider, (String)"pluginInfoReleaseProvider");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)((Object)updateManager), (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)((Object)pluginManager), (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)springPluginStatusProvider, (String)"springPluginStatusProvider");
        this.pluginInfoReleaseProvider = pluginInfoReleaseProvider;
        this.applicationEventPublisher = applicationEventPublisher;
        this.updateManager = updateManager;
        this.pluginManager = pluginManager;
        this.springPluginStatusProvider = springPluginStatusProvider;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ RemotePluginInfoReleaseCache this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        Cache cache = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder()\n    .build<\u2026ing, PluginInfoRelease>()");
        this.pluginCache = cache;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedDelayString="${spinnaker.extensibility.remote-plugins.cache-refresh-interval-ms:60000}", initialDelay=0L)
    public final void refresh() {
        void $this$filterTo$iv$iv;
        Object it;
        void $this$filterTo$iv$iv2;
        this.updateManager.refresh();
        Iterable $this$filter$iv = this.updateManager.getPlugins();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (SpinnakerPluginInfo)((Object)element$iv$iv);
            boolean bl = false;
            String string = ((SpinnakerPluginInfo)((Object)it)).id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            if (!this.springPluginStatusProvider.isPluginEnabled(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledPlugins = (List)destination$iv$iv;
        boolean $i$a$-let-RemotePluginInfoReleaseCache$refresh$enabledPlugins$32 = false;
        $this$filter$iv = this.pluginInfoReleaseProvider.getReleases(enabledPlugins);
        $i$f$filter = false;
        Iterable $i$a$-let-RemotePluginInfoReleaseCache$refresh$enabledPlugins$32 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PluginInfoRelease)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)((PluginInfoRelease)it).getProps().getRemoteExtensions()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledPlugins2 = (List)destination$iv$iv;
        this.remove(enabledPlugins2);
        this.addOrUpdate(enabledPlugins2);
        this.getLog().info("Cached " + this.pluginCache.estimatedSize() + " remote plugin configurations.");
    }

    @Nullable
    public final PluginInfoRelease get(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return (PluginInfoRelease)this.pluginCache.getIfPresent((Object)pluginId);
    }

    /*
     * WARNING - void declaration
     */
    private final void remove(List<PluginInfoRelease> enabledPlugins) {
        void $this$filterNotTo$iv$iv;
        ConcurrentMap concurrentMap = this.pluginCache.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"pluginCache.asMap()");
        Map $this$filterNot$iv = concurrentMap;
        boolean $i$f$filterNot = false;
        Object object = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry cachedPlugin = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable $this$map$iv = enabledPlugins;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PluginInfoRelease pluginInfoRelease = (PluginInfoRelease)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getPluginId());
            }
            if (((List)destination$iv$iv2).contains(cachedPlugin.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map disabledPlugins = destination$iv$iv;
        if (!disabledPlugins.isEmpty()) {
            Map $this$forEach$iv = disabledPlugins;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry disabledPlugin = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                this.getLog().debug("Removing remote plugin configuration '{}' from cache.", disabledPlugin.getKey());
                this.pluginCache.invalidate(disabledPlugin.getKey());
                Object k = disabledPlugin.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"disabledPlugin.key");
                String string = (String)k;
                String string2 = ((PluginInfoRelease)disabledPlugin.getValue()).getProps().version;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"disabledPlugin.value.props.version");
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new RemotePluginConfigChanged(this, RemotePluginConfigChanged.Status.DISABLED, string, string2, ((PluginInfoRelease)disabledPlugin.getValue()).getProps().getRemoteExtensions()));
            }
        }
    }

    private final void addOrUpdate(List<PluginInfoRelease> enabledPlugins) {
        Iterable $this$forEach$iv = enabledPlugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginInfoRelease enabledPlugin = (PluginInfoRelease)element$iv;
            boolean bl = false;
            PluginInfoRelease cachedRelease = (PluginInfoRelease)this.pluginCache.getIfPresent((Object)enabledPlugin.getPluginId());
            if (cachedRelease == null) {
                String string = enabledPlugin.getPluginId();
                String string2 = enabledPlugin.getProps().requires;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enabledPlugin.props.requires");
                if (this.versionConstraint(string, string2)) {
                    this.getLog().debug("Adding remote plugin configuration '{}' to cache.", (Object)enabledPlugin.getPluginId());
                    this.pluginCache.put((Object)enabledPlugin.getPluginId(), (Object)enabledPlugin);
                    String string3 = enabledPlugin.getPluginId();
                    String string4 = enabledPlugin.getProps().version;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"enabledPlugin.props.version");
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new RemotePluginConfigChanged(this, RemotePluginConfigChanged.Status.ENABLED, string3, string4, enabledPlugin.getProps().getRemoteExtensions()));
                    continue;
                }
            }
            if (cachedRelease != null && !Intrinsics.areEqual((Object)cachedRelease.getProps().version, (Object)enabledPlugin.getProps().version)) {
                String string = enabledPlugin.getPluginId();
                String string5 = enabledPlugin.getProps().requires;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"enabledPlugin.props.requires");
                if (this.versionConstraint(string, string5)) {
                    this.getLog().debug("Updating remote plugin configuration '{}' in cache.", (Object)enabledPlugin.getPluginId());
                    this.pluginCache.put((Object)enabledPlugin.getPluginId(), (Object)enabledPlugin);
                    String string6 = enabledPlugin.getPluginId();
                    String string7 = enabledPlugin.getProps().version;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"enabledPlugin.props.version");
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new RemotePluginConfigChanged(this, RemotePluginConfigChanged.Status.UPDATED, string6, string7, enabledPlugin.getProps().getRemoteExtensions()));
                    continue;
                }
            }
            this.getLog().debug("No remote plugin versions found that need to be enabled or updated.");
        }
    }

    private final boolean versionConstraint(String pluginId, String requires) {
        boolean bl;
        if (this.pluginManager.getSpinnakerVersionManager().checkVersionConstraint(this.pluginManager.getSystemVersion(), requires)) {
            bl = true;
        } else {
            Object[] objectArray = new Object[]{pluginId, this.pluginManager.getSystemVersion(), requires};
            this.getLog().warn("Requested enabled remote plugin '{}' is not compatible with system version '{}', requires '{}'", objectArray);
            bl = false;
        }
        return bl;
    }
}

