/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClient;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientConfig;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientRegistry;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.Ok3HttpClient;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.OkHttp3ClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0011\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0096\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0016R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClientRegistry;", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientRegistry;", "pluginId", "", "environment", "Lorg/springframework/core/env/Environment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "okHttp3ClientFactory", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;", "okHttp3ClientConfiguration", "Lcom/netflix/spinnaker/config/OkHttp3ClientConfiguration;", "(Ljava/lang/String;Lorg/springframework/core/env/Environment;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;Lcom/netflix/spinnaker/config/OkHttp3ClientConfiguration;)V", "clients", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClient;", "getClients$kork_plugins", "()Ljava/util/Map;", "internalServicesClient", "Lokhttp3/OkHttpClient;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "okClients", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientConfig;", "getOkClients$kork_plugins", "configure", "", "name", "baseUrl", "config", "findInternalServiceBaseUrl", "get", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClient;", "getInternalService", "Companion", "kork-plugins"})
public final class Ok3HttpClientRegistry
implements HttpClientRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pluginId;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final OkHttp3ClientFactory okHttp3ClientFactory;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final OkHttpClient internalServicesClient;
    @NotNull
    private final Map<HttpClientConfig, OkHttpClient> okClients;
    @NotNull
    private final Map<String, Ok3HttpClient> clients;
    @NotNull
    private static final String serviceNamePlaceholder = "SERVICE_NAME";
    @NotNull
    private static final List<String> baseUrlPaths;

    public Ok3HttpClientRegistry(@NotNull String pluginId, @NotNull Environment environment, @NotNull ObjectMapper objectMapper, @NotNull OkHttp3ClientFactory okHttp3ClientFactory, @NotNull OkHttp3ClientConfiguration okHttp3ClientConfiguration) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)okHttp3ClientFactory, (String)"okHttp3ClientFactory");
        Intrinsics.checkNotNullParameter((Object)okHttp3ClientConfiguration, (String)"okHttp3ClientConfiguration");
        this.pluginId = pluginId;
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.okHttp3ClientFactory = okHttp3ClientFactory;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Ok3HttpClientRegistry this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.internalServicesClient = okHttp3ClientConfiguration.create().build();
        this.okClients = new ConcurrentHashMap();
        this.clients = new ConcurrentHashMap();
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Map<HttpClientConfig, OkHttpClient> getOkClients$kork_plugins() {
        return this.okClients;
    }

    @NotNull
    public final Map<String, Ok3HttpClient> getClients$kork_plugins() {
        return this.clients;
    }

    public void configure(@NotNull String name, @NotNull String baseUrl, @NotNull HttpClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.clients.computeIfAbsent(this.pluginId + "." + name, arg_0 -> Ok3HttpClientRegistry.configure$lambda-1(this, name, config, baseUrl, arg_0));
    }

    @NotNull
    public HttpClient get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Ok3HttpClient ok3HttpClient = this.clients.get(this.pluginId + "." + name);
        if (ok3HttpClient == null) {
            throw new IntegrationException("No client configured for '" + name + "'");
        }
        return ok3HttpClient;
    }

    @NotNull
    public HttpClient getInternalService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Ok3HttpClient ok3HttpClient = this.clients.computeIfAbsent("internal." + name, arg_0 -> Ok3HttpClientRegistry.getInternalService$lambda-2(name, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)ok3HttpClient, (String)"clients.computeIfAbsent(\u2026ient, objectMapper)\n    }");
        return ok3HttpClient;
    }

    /*
     * WARNING - void declaration
     */
    private final String findInternalServiceBaseUrl(String name) {
        void $this$mapTo$iv$iv;
        String string = name.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        String normalized = string;
        Iterable $this$map$iv = baseUrlPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)serviceNamePlaceholder, (String)normalized, (boolean)false, (int)4, null));
        }
        List paths = (List)destination$iv$iv;
        for (String path : paths) {
            String baseUrl = this.environment.getProperty(path);
            if (baseUrl == null) continue;
            return baseUrl;
        }
        throw new IntegrationException("Unknown service '" + name + "': No baseUrl config property set for service");
    }

    private static final OkHttpClient configure$lambda-1$lambda-0(Ok3HttpClientRegistry this$0, String $name, String $baseUrl, HttpClientConfig $config, HttpClientConfig it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$baseUrl, (String)"$baseUrl");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getLog().info("No existing OkHttpClient with a matching config requested by '" + this$0.pluginId + "." + $name + "', creating one");
        return this$0.okHttp3ClientFactory.create($baseUrl, $config);
    }

    private static final Ok3HttpClient configure$lambda-1(Ok3HttpClientRegistry this$0, String $name, HttpClientConfig $config, String $baseUrl, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$baseUrl, (String)"$baseUrl");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getLog().info("Configuring HTTP client for '" + this$0.pluginId + "' named '" + $name + "'");
        OkHttpClient okHttpClient = this$0.okClients.computeIfAbsent($config, arg_0 -> Ok3HttpClientRegistry.configure$lambda-1$lambda-0(this$0, $name, $baseUrl, $config, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"okClients.computeIfAbsen\u2026(baseUrl, config)\n      }");
        OkHttpClient okClient = okHttpClient;
        return new Ok3HttpClient(this$0.pluginId + "." + $name, this$0.okHttp3ClientFactory.normalizeBaseUrl($baseUrl), okClient, this$0.objectMapper);
    }

    private static final Ok3HttpClient getInternalService$lambda-2(String $name, Ok3HttpClientRegistry this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Ok3HttpClient("internal." + $name, this$0.findInternalServiceBaseUrl($name), this$0.internalServicesClient, this$0.objectMapper);
    }

    static {
        Object[] objectArray = new String[]{"SERVICE_NAME.baseUrl", "services.SERVICE_NAME.baseUrl"};
        baseUrlPaths = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClientRegistry$Companion;", "", "()V", "baseUrlPaths", "", "", "serviceNamePlaceholder", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

