/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.release.source;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.spinnaker.kork.plugins.update.SpinnakerUpdateManager;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.source.PluginInfoReleaseSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.update.PluginInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0002R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/release/source/LatestPluginInfoReleaseSource;", "Lcom/netflix/spinnaker/kork/plugins/update/release/source/PluginInfoReleaseSource;", "updateManager", "Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;", "serviceName", "", "(Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getOrder", "", "getReleases", "", "Lcom/netflix/spinnaker/kork/plugins/update/release/PluginInfoRelease;", "pluginInfo", "", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo;", "pluginInfoRelease", "Companion", "kork-plugins"})
public final class LatestPluginInfoReleaseSource
implements PluginInfoReleaseSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpinnakerUpdateManager updateManager;
    @Nullable
    private final String serviceName;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();

    public LatestPluginInfoReleaseSource(@NotNull SpinnakerUpdateManager updateManager, @Nullable String serviceName) {
        Intrinsics.checkNotNullParameter((Object)((Object)updateManager), (String)"updateManager");
        this.updateManager = updateManager;
        this.serviceName = serviceName;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ LatestPluginInfoReleaseSource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    public /* synthetic */ LatestPluginInfoReleaseSource(SpinnakerUpdateManager spinnakerUpdateManager, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(spinnakerUpdateManager, string);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<PluginInfoRelease> getReleases(@NotNull List<SpinnakerPluginInfo> pluginInfo) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginInfo, (String)"pluginInfo");
        Iterable $this$mapNotNull$iv = pluginInfo;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PluginInfoRelease it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpinnakerPluginInfo it = (SpinnakerPluginInfo)((Object)element$iv$iv);
            boolean bl2 = false;
            if (this.pluginInfoRelease(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final PluginInfoRelease pluginInfoRelease(SpinnakerPluginInfo pluginInfo) {
        PluginInfoRelease pluginInfoRelease;
        PluginInfo.PluginRelease latestRelease;
        if (this.serviceName == null) {
            v0 = this.updateManager.getLastPluginRelease(pluginInfo.id);
        } else {
            String string = pluginInfo.id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginInfo.id");
            v0 = latestRelease = this.updateManager.getLastPluginRelease(string, this.serviceName);
        }
        if (latestRelease != null) {
            this.getLog().debug("Latest release version '{}' for plugin '{}'", (Object)latestRelease.version, (Object)pluginInfo.id);
            String string = pluginInfo.id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginInfo.id");
            Object object = objectMapper.convertValue((Object)latestRelease, SpinnakerPluginInfo.SpinnakerPluginRelease.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026luginRelease::class.java)");
            pluginInfoRelease = new PluginInfoRelease(string, (SpinnakerPluginInfo.SpinnakerPluginRelease)((Object)object));
        } else {
            this.getLog().debug("Latest release version not found for plugin '{}'", (Object)pluginInfo.id);
            pluginInfoRelease = null;
        }
        return pluginInfoRelease;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void processReleases(@NotNull Set<PluginInfoRelease> pluginInfoReleases) {
        PluginInfoReleaseSource.DefaultImpls.processReleases(this, pluginInfoReleases);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/release/source/LatestPluginInfoReleaseSource$Companion;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

