/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.downloader;

import com.netflix.spinnaker.kork.annotations.VisibleForTesting;
import com.netflix.spinnaker.kork.plugins.config.Configurable;
import com.netflix.spinnaker.kork.plugins.update.downloader.ProcessFileDownloaderConfig;
import com.netflix.spinnaker.kork.plugins.update.downloader.internal.DefaultProcessRunner;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pf4j.update.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable(value=ProcessFileDownloaderConfig.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloader;", "Lorg/pf4j/update/FileDownloader;", "config", "Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloaderConfig;", "(Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloaderConfig;)V", "processRunner", "Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloader$ProcessRunner;", "(Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloaderConfig;Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloader$ProcessRunner;)V", "getConfig$kork_plugins", "()Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloaderConfig;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "downloadFile", "Ljava/nio/file/Path;", "fileUrl", "Ljava/net/URL;", "ProcessRunner", "kork-plugins"})
public final class ProcessFileDownloader
implements FileDownloader {
    @VisibleForTesting
    @NotNull
    private final ProcessFileDownloaderConfig config;
    @NotNull
    private final ProcessRunner processRunner;
    @NotNull
    private final Lazy log$delegate;

    public ProcessFileDownloader(@NotNull ProcessFileDownloaderConfig config, @NotNull ProcessRunner processRunner) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        this.config = config;
        this.processRunner = processRunner;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ ProcessFileDownloader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    @NotNull
    public final ProcessFileDownloaderConfig getConfig$kork_plugins() {
        return this.config;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public ProcessFileDownloader(@NotNull ProcessFileDownloaderConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(config, new DefaultProcessRunner());
    }

    @NotNull
    public Path downloadFile(@NotNull URL fileUrl) {
        ProcessBuilder processBuilder;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        this.getLog().debug("Downloading plugin binary: " + fileUrl);
        ProcessBuilder $this$downloadFile_u24lambda_u2d0 = processBuilder = new ProcessBuilder(new String[0]);
        boolean bl = false;
        $this$downloadFile_u24lambda_u2d0.directory(Files.createTempDirectory("plugin-downloads", new FileAttribute[0]).toFile());
        $this$downloadFile_u24lambda_u2d0.environment().putAll(this.config.getEnv());
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.config.getCommand(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray3 = stringArray2;
        $this$downloadFile_u24lambda_u2d0.command(Arrays.copyOf(stringArray3, stringArray3.length));
        ProcessBuilder builder = processBuilder;
        Path path = Paths.get(this.processRunner.completeOrTimeout(builder), new String[0]);
        this.getLog().debug("Received downloaded plugin path: " + path + " (from " + fileUrl + ")");
        if (!path.toFile().exists()) {
            throw new FileNotFoundException("The downloaded file could not be found on the file system");
        }
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        return path;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/downloader/ProcessFileDownloader$ProcessRunner;", "", "completeOrTimeout", "", "processBuilder", "Ljava/lang/ProcessBuilder;", "kork-plugins"})
    public static interface ProcessRunner {
        @NotNull
        public String completeOrTimeout(@NotNull ProcessBuilder var1);
    }
}

