/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.v2;

import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager;
import com.netflix.spinnaker.kork.plugins.SpringPluginStatusProvider;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.kork.plugins.api.spring.PrivilegedSpringPlugin;
import com.netflix.spinnaker.kork.plugins.events.ExtensionCreated;
import com.netflix.spinnaker.kork.plugins.proxy.LazyExtensionInvocationProxy;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect;
import com.netflix.spinnaker.kork.plugins.update.SpinnakerUpdateManager;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.provider.PluginInfoReleaseProvider;
import com.netflix.spinnaker.kork.plugins.v2.DslKt;
import com.netflix.spinnaker.kork.plugins.v2.PluginContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Plugin;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/kork/plugins/v2/SpinnakerPluginService;", "", "pluginManager", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "updateManager", "Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;", "pluginInfoReleaseProvider", "Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;", "springPluginStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;", "invocationAspects", "", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationAspect;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;Ljava/util/List;Lorg/springframework/context/ApplicationEventPublisher;)V", "initialized", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "initialize", "", "registerProxies", "container", "Lcom/netflix/spinnaker/kork/plugins/v2/PluginContainer;", "registry", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;", "initializerBeanName", "", "startPlugins", "withTiming", "task", "callback", "Lkotlin/Function0;", "kork-plugins"})
public final class SpinnakerPluginService {
    @NotNull
    private final SpinnakerPluginManager pluginManager;
    @NotNull
    private final SpinnakerUpdateManager updateManager;
    @NotNull
    private final PluginInfoReleaseProvider pluginInfoReleaseProvider;
    @NotNull
    private final SpringPluginStatusProvider springPluginStatusProvider;
    @NotNull
    private final List<InvocationAspect<?>> invocationAspects;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Logger log;
    private boolean initialized;

    public SpinnakerPluginService(@NotNull SpinnakerPluginManager pluginManager, @NotNull SpinnakerUpdateManager updateManager, @NotNull PluginInfoReleaseProvider pluginInfoReleaseProvider, @NotNull SpringPluginStatusProvider springPluginStatusProvider, @NotNull List<? extends InvocationAspect<?>> invocationAspects, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginManager), (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)((Object)updateManager), (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)pluginInfoReleaseProvider, (String)"pluginInfoReleaseProvider");
        Intrinsics.checkNotNullParameter((Object)springPluginStatusProvider, (String)"springPluginStatusProvider");
        Intrinsics.checkNotNullParameter(invocationAspects, (String)"invocationAspects");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.pluginManager = pluginManager;
        this.updateManager = updateManager;
        this.pluginInfoReleaseProvider = pluginInfoReleaseProvider;
        this.springPluginStatusProvider = springPluginStatusProvider;
        this.invocationAspects = invocationAspects;
        this.applicationEventPublisher = applicationEventPublisher;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public final void initialize() {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"Plugin framework has already been initialized");
        this.withTiming("initializing plugins", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SpinnakerPluginService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable<E> $this$filter$iv;
                SpinnakerPluginService.access$getPluginManager$p(this.this$0).loadPlugins();
                Iterable iterable = SpinnakerPluginService.access$getUpdateManager$p(this.this$0).getPlugins();
                SpinnakerPluginService spinnakerPluginService = this.this$0;
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    SpinnakerPluginInfo it = (SpinnakerPluginInfo)((Object)element$iv$iv);
                    boolean bl = false;
                    SpringPluginStatusProvider springPluginStatusProvider = SpinnakerPluginService.access$getSpringPluginStatusProvider$p(spinnakerPluginService);
                    String string = it.id;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                    if (!springPluginStatusProvider.isPluginEnabled(string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                spinnakerPluginService = this.this$0;
                List enabledPlugins = $this$filter$iv;
                boolean bl = false;
                Set<PluginInfoRelease> releases = SpinnakerPluginService.access$getPluginInfoReleaseProvider$p(spinnakerPluginService).getReleases(enabledPlugins);
                $this$filter$iv = SpinnakerPluginService.access$getUpdateManager$p(this.this$0).downloadPluginReleases$kork_plugins(releases);
                spinnakerPluginService = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Path pluginPath = (Path)element$iv;
                    boolean bl2 = false;
                    SpinnakerPluginService.access$getPluginManager$p(spinnakerPluginService).loadPlugin(pluginPath);
                }
            }
        }));
    }

    public final void startPlugins(@NotNull BeanDefinitionRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.withTiming("starting plugins", (Function0<Unit>)((Function0)new Function0<Unit>(this, registry){
            final /* synthetic */ SpinnakerPluginService this$0;
            final /* synthetic */ BeanDefinitionRegistry $registry;
            {
                this.this$0 = $receiver;
                this.$registry = $registry;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                SpinnakerPluginService.access$getPluginManager$p(this.this$0).startPlugins();
                List list = SpinnakerPluginService.access$getPluginManager$p(this.this$0).getStartedPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pluginManager.startedPlugins");
                Iterable iterable = list;
                BeanDefinitionRegistry beanDefinitionRegistry = this.$registry;
                SpinnakerPluginService spinnakerPluginService = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PluginWrapper pluginWrapper = (PluginWrapper)element$iv;
                    boolean bl = false;
                    Plugin p = pluginWrapper.getPlugin();
                    if (p instanceof PrivilegedSpringPlugin) {
                        ((PrivilegedSpringPlugin)p).registerBeanDefinitions(beanDefinitionRegistry);
                    }
                    if (!(p instanceof PluginContainer)) continue;
                    String initializerBeanName = ((PluginContainer)p).registerInitializer(beanDefinitionRegistry);
                    SpinnakerPluginService.access$registerProxies(spinnakerPluginService, (PluginContainer)p, beanDefinitionRegistry, initializerBeanName);
                }
            }
        }));
    }

    private final void registerProxies(PluginContainer container, BeanDefinitionRegistry registry, String initializerBeanName) {
        ClassPathScanningCandidateComponentProvider classPathScanningCandidateComponentProvider;
        GenericApplicationContext pluginContext = container.getPluginContext$kork_plugins();
        String pluginId = container.getWrapper().getDescriptor().getPluginId();
        ClassPathScanningCandidateComponentProvider $this$registerProxies_u24lambda_u2d0 = classPathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        boolean bl = false;
        $this$registerProxies_u24lambda_u2d0.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SpinnakerExtensionPoint.class));
        $this$registerProxies_u24lambda_u2d0.setResourceLoader((ResourceLoader)new DefaultResourceLoader(container.getWrapper().getPluginClassLoader()));
        Set set = classPathScanningCandidateComponentProvider.findCandidateComponents(DslKt.getBasePackageName(container.getActual()));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ClassPathScanningCandida\u2026r.actual.basePackageName)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractBeanDefinition abstractBeanDefinition;
            Class<?> extensionBeanClass;
            BeanDefinition extensionBeanDefinition = (BeanDefinition)element$iv;
            boolean bl2 = false;
            if (container.getWrapper().getPluginClassLoader().loadClass(extensionBeanDefinition.getBeanClassName()) == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint>");
            }
            String pluginContextBeanName = AnnotationBeanNameGenerator.INSTANCE.generateBeanName(extensionBeanDefinition, (BeanDefinitionRegistry)pluginContext);
            PluginDescriptor pluginDescriptor = container.getWrapper().getDescriptor();
            if (pluginDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor");
            }
            Object proxy2 = LazyExtensionInvocationProxy.Companion.proxy((Lazy<? extends SpinnakerExtensionPoint>)LazyKt.lazy((Function0)((Function0)new Function0<SpinnakerExtensionPoint>(pluginContext, pluginId, pluginContextBeanName, initializerBeanName){
                final /* synthetic */ GenericApplicationContext $pluginContext;
                final /* synthetic */ String $pluginId;
                final /* synthetic */ String $pluginContextBeanName;
                final /* synthetic */ String $initializerBeanName;
                {
                    this.$pluginContext = $pluginContext;
                    this.$pluginId = $pluginId;
                    this.$pluginContextBeanName = $pluginContextBeanName;
                    this.$initializerBeanName = $initializerBeanName;
                    super(0);
                }

                @NotNull
                public final SpinnakerExtensionPoint invoke() {
                    ApplicationContext applicationContext = this.$pluginContext.getParent();
                    if (applicationContext == null) {
                        throw new IllegalStateException("Plugin context for \"" + this.$pluginId + "\" was not configured with a parent context");
                    }
                    ApplicationContext applicationContext2 = applicationContext;
                    String string = this.$initializerBeanName;
                    ApplicationContext it = applicationContext2;
                    boolean bl = false;
                    it.getBean(string);
                    Object object = this.$pluginContext.getBean(this.$pluginContextBeanName);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint");
                    }
                    return (SpinnakerExtensionPoint)object;
                }
            })), extensionBeanClass, this.invocationAspects, (SpinnakerPluginDescriptor)pluginDescriptor);
            AbstractBeanDefinition $this$registerProxies_u24lambda_u2d3_u24lambda_u2d2 = abstractBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition().getBeanDefinition();
            boolean bl3 = false;
            $this$registerProxies_u24lambda_u2d3_u24lambda_u2d2.setInstanceSupplier(() -> SpinnakerPluginService.registerProxies$lambda-3$lambda-2$lambda-1(proxy2));
            $this$registerProxies_u24lambda_u2d3_u24lambda_u2d2.setBeanClass(extensionBeanClass);
            AbstractBeanDefinition proxyBeanDefinition = abstractBeanDefinition;
            String string = extensionBeanClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionBeanClass.simpleName");
            registry.registerBeanDefinition(pluginId + "_" + StringsKt.decapitalize((String)string), (BeanDefinition)proxyBeanDefinition);
            Intrinsics.checkNotNullExpressionValue((Object)pluginContextBeanName, (String)"pluginContextBeanName");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ExtensionCreated(this, pluginContextBeanName, proxy2, extensionBeanClass));
        }
    }

    private final void withTiming(String task, Function0<Unit> callback) {
        long start = System.currentTimeMillis();
        this.log.debug(StringsKt.capitalize((String)task));
        callback.invoke();
        this.log.debug("Finished " + task + " in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private static final Object registerProxies$lambda-3$lambda-2$lambda-1(Object $proxy) {
        Intrinsics.checkNotNullParameter((Object)$proxy, (String)"$proxy");
        return $proxy;
    }

    public static final /* synthetic */ SpinnakerPluginManager access$getPluginManager$p(SpinnakerPluginService $this) {
        return $this.pluginManager;
    }

    public static final /* synthetic */ SpinnakerUpdateManager access$getUpdateManager$p(SpinnakerPluginService $this) {
        return $this.updateManager;
    }

    public static final /* synthetic */ SpringPluginStatusProvider access$getSpringPluginStatusProvider$p(SpinnakerPluginService $this) {
        return $this.springPluginStatusProvider;
    }

    public static final /* synthetic */ PluginInfoReleaseProvider access$getPluginInfoReleaseProvider$p(SpinnakerPluginService $this) {
        return $this.pluginInfoReleaseProvider;
    }

    public static final /* synthetic */ void access$registerProxies(SpinnakerPluginService $this, PluginContainer container, BeanDefinitionRegistry registry, String initializerBeanName) {
        $this.registerProxies(container, registry, initializerBeanName);
    }
}

