/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.proto.stats;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.ProtocolMessageEnum;
import com.netflix.spinnaker.kork.proto.stats.Log;

public enum Status implements ProtocolMessageEnum
{
    UNKNOWN(0),
    NOT_STARTED(1),
    RUNNING(2),
    PAUSED(3),
    SUSPENDED(4),
    SUCCEEDED(5),
    FAILED_CONTINUE(6),
    TERMINAL(7),
    CANCELED(8),
    REDIRECT(9),
    STOPPED(10),
    SKIPPED(11),
    BUFFERED(12),
    UNRECOGNIZED(-1);

    public static final int UNKNOWN_VALUE = 0;
    public static final int NOT_STARTED_VALUE = 1;
    public static final int RUNNING_VALUE = 2;
    public static final int PAUSED_VALUE = 3;
    public static final int SUSPENDED_VALUE = 4;
    public static final int SUCCEEDED_VALUE = 5;
    public static final int FAILED_CONTINUE_VALUE = 6;
    public static final int TERMINAL_VALUE = 7;
    public static final int CANCELED_VALUE = 8;
    public static final int REDIRECT_VALUE = 9;
    public static final int STOPPED_VALUE = 10;
    public static final int SKIPPED_VALUE = 11;
    public static final int BUFFERED_VALUE = 12;
    private static final Internal.EnumLiteMap<Status> internalValueMap;
    private static final Status[] VALUES;
    private final int value;

    public final int getNumber() {
        if (this == UNRECOGNIZED) {
            throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
        }
        return this.value;
    }

    @Deprecated
    public static Status valueOf(int value) {
        return Status.forNumber(value);
    }

    public static Status forNumber(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return NOT_STARTED;
            }
            case 2: {
                return RUNNING;
            }
            case 3: {
                return PAUSED;
            }
            case 4: {
                return SUSPENDED;
            }
            case 5: {
                return SUCCEEDED;
            }
            case 6: {
                return FAILED_CONTINUE;
            }
            case 7: {
                return TERMINAL;
            }
            case 8: {
                return CANCELED;
            }
            case 9: {
                return REDIRECT;
            }
            case 10: {
                return STOPPED;
            }
            case 11: {
                return SKIPPED;
            }
            case 12: {
                return BUFFERED;
            }
        }
        return null;
    }

    public static Internal.EnumLiteMap<Status> internalGetValueMap() {
        return internalValueMap;
    }

    public final Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
            throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
        }
        return (Descriptors.EnumValueDescriptor)Status.getDescriptor().getValues().get(this.ordinal());
    }

    public final Descriptors.EnumDescriptor getDescriptorForType() {
        return Status.getDescriptor();
    }

    public static final Descriptors.EnumDescriptor getDescriptor() {
        return (Descriptors.EnumDescriptor)Log.getDescriptor().getEnumTypes().get(0);
    }

    public static Status valueOf(Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != Status.getDescriptor()) {
            throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
    }

    private Status(int value) {
        this.value = value;
    }

    static {
        internalValueMap = new Internal.EnumLiteMap<Status>(){

            public Status findValueByNumber(int number) {
                return Status.forNumber(number);
            }
        };
        VALUES = Status.values();
    }
}

