/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.pubsub.aws;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.aws.ARN;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.pubsub.aws.PubSubUtils;
import com.netflix.spinnaker.kork.pubsub.aws.config.AmazonPubsubProperties;
import com.netflix.spinnaker.kork.pubsub.model.PubsubPublisher;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SNSPublisher
implements PubsubPublisher {
    private static final Logger log = LoggerFactory.getLogger(SNSPublisher.class);
    private final AmazonSNS amazonSNS;
    private final AmazonPubsubProperties.AmazonPubsubSubscription subscription;
    private final Registry registry;
    private final Supplier<Boolean> isEnabled;
    private final ARN topicARN;
    private final RetrySupport retrySupport;
    private Counter successCounter;

    public SNSPublisher(AmazonPubsubProperties.AmazonPubsubSubscription subscription, AmazonSNS amazonSNS, Supplier<Boolean> isEnabled, Registry registry, RetrySupport retrySupport) {
        this.subscription = subscription;
        this.amazonSNS = amazonSNS;
        this.isEnabled = isEnabled;
        this.registry = registry;
        this.topicARN = new ARN(subscription.getTopicARN());
        this.successCounter = registry.counter("pubsub.amazon.published", new String[]{"topic", this.getTopicName()});
        this.retrySupport = retrySupport;
        this.initializeTopic();
    }

    public String getPubsubSystem() {
        return "amazon";
    }

    public String getTopicName() {
        return this.subscription.getName();
    }

    public String getName() {
        return this.getTopicName();
    }

    private void initializeTopic() {
        PubSubUtils.ensureTopicExists(this.amazonSNS, this.topicARN, this.subscription);
    }

    public void publish(String message, Map<String, String> attributes) {
        this.publishMessage(message);
    }

    public Optional<PublishResult> publishMessage(String message) {
        if (!this.isEnabled.get().booleanValue()) {
            log.warn("Publishing is disabled for topic {}, dropping message {}", (Object)this.topicARN, (Object)message);
            return Optional.empty();
        }
        try {
            PublishRequest publishRequest = new PublishRequest(this.topicARN.getArn(), message);
            PublishResult publishResponse = (PublishResult)this.retrySupport.retry(() -> this.amazonSNS.publish(publishRequest), 5, Duration.ofMillis(200L), false);
            log.debug("Published message {} with id {} to topic {}", new Object[]{message, publishResponse.getMessageId(), this.topicARN});
            this.getSuccessCounter().increment();
            return Optional.of(publishResponse);
        }
        catch (Exception e) {
            log.error("failed to publish message {} to topic {}", new Object[]{message, this.topicARN, e});
            this.getErrorCounter(e).increment();
            return Optional.empty();
        }
    }

    private Counter getSuccessCounter() {
        return this.successCounter;
    }

    private Counter getErrorCounter(Exception e) {
        return this.registry.counter("pubsub.amazon.publishFailed", new String[]{"topic", this.getTopicName(), "exceptionClass", e.getClass().getSimpleName()});
    }
}

