/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.pubsub.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.aws.ARN;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusListener;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.pubsub.PubsubPublishers;
import com.netflix.spinnaker.kork.pubsub.aws.PubSubUtils;
import com.netflix.spinnaker.kork.pubsub.aws.SNSPublisher;
import com.netflix.spinnaker.kork.pubsub.aws.config.AmazonPubsubProperties;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"pubsub.enabled", "pubsub.amazon.enabled"})
public class SNSPublisherProvider {
    private static final Logger log = LoggerFactory.getLogger(SNSPublisherProvider.class);
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final AmazonPubsubProperties properties;
    private final PubsubPublishers pubsubPublishers;
    private final Registry registry;
    private final RetrySupport retrySupport;
    private final DiscoveryStatusListener discoveryStatus;
    private final DynamicConfigService dynamicConfig;

    @Autowired
    public SNSPublisherProvider(AWSCredentialsProvider awsCredentialsProvider, AmazonPubsubProperties properties, PubsubPublishers pubsubPublishers, Registry registry, RetrySupport retrySupport, DiscoveryStatusListener discoveryStatus, DynamicConfigService dynamicConfig) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.properties = properties;
        this.pubsubPublishers = pubsubPublishers;
        this.registry = registry;
        this.retrySupport = retrySupport;
        this.discoveryStatus = discoveryStatus;
        this.dynamicConfig = dynamicConfig;
    }

    @PostConstruct
    public void start() {
        if (this.properties == null) {
            return;
        }
        ArrayList publishers = new ArrayList();
        this.properties.getSubscriptions().forEach(subscription -> {
            ARN topicARN = new ARN(subscription.getTopicARN());
            log.info("Bootstrapping SNS topic: {}", (Object)topicARN);
            AmazonSNS amazonSNS = (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withClientConfiguration(new ClientConfiguration())).withRegion(topicARN.getRegion())).build();
            Supplier<Boolean> isEnabled = PubSubUtils.getEnabledSupplier(this.dynamicConfig, subscription, this.discoveryStatus);
            SNSPublisher publisher = new SNSPublisher((AmazonPubsubProperties.AmazonPubsubSubscription)subscription, amazonSNS, isEnabled, this.registry, this.retrySupport);
            publishers.add(publisher);
        });
        this.pubsubPublishers.putAll(publishers);
    }
}

