/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.pubsub.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.google.common.base.Preconditions;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.aws.ARN;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusListener;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.pubsub.PubsubSubscribers;
import com.netflix.spinnaker.kork.pubsub.aws.PubSubUtils;
import com.netflix.spinnaker.kork.pubsub.aws.SQSSubscriber;
import com.netflix.spinnaker.kork.pubsub.aws.api.AmazonMessageAcknowledger;
import com.netflix.spinnaker.kork.pubsub.aws.api.AmazonPubsubMessageHandlerFactory;
import com.netflix.spinnaker.kork.pubsub.aws.config.AmazonPubsubProperties;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"pubsub.enabled", "pubsub.amazon.enabled"})
public class SQSSubscriberProvider {
    private static final Logger log = LoggerFactory.getLogger(SQSSubscriberProvider.class);
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final AmazonPubsubProperties properties;
    private final PubsubSubscribers pubsubSubscribers;
    private final AmazonPubsubMessageHandlerFactory pubsubMessageHandlerFactory;
    private final Registry registry;
    private final DiscoveryStatusListener discoveryStatus;
    private final DynamicConfigService dynamicConfig;
    private final AmazonMessageAcknowledger messageAcknowledger;

    @Autowired
    public SQSSubscriberProvider(AWSCredentialsProvider awsCredentialsProvider, AmazonPubsubProperties properties, PubsubSubscribers pubsubSubscribers, AmazonPubsubMessageHandlerFactory pubsubMessageHandlerFactory, AmazonMessageAcknowledger messageAcknowledger, Registry registry, DiscoveryStatusListener discoveryStatus, DynamicConfigService dynamicConfig) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.properties = properties;
        this.pubsubSubscribers = pubsubSubscribers;
        this.pubsubMessageHandlerFactory = pubsubMessageHandlerFactory;
        this.messageAcknowledger = messageAcknowledger;
        this.registry = registry;
        this.discoveryStatus = discoveryStatus;
        this.dynamicConfig = dynamicConfig;
    }

    @PostConstruct
    public void start() {
        Preconditions.checkNotNull((Object)this.properties, (Object)"Can't initialize SQSSubscriberProvider with null properties");
        ExecutorService executorService = Executors.newFixedThreadPool(this.properties.getSubscriptions().size());
        ArrayList subscribers = new ArrayList();
        this.properties.getSubscriptions().forEach(subscription -> {
            log.info("Bootstrapping SQS for SNS topic: {}", (Object)subscription.getTopicARN());
            ARN queueArn = new ARN(subscription.getQueueARN());
            ARN topicArn = new ARN(subscription.getTopicARN());
            SQSSubscriber worker = new SQSSubscriber((AmazonPubsubProperties.AmazonPubsubSubscription)subscription, this.pubsubMessageHandlerFactory.create((AmazonPubsubProperties.AmazonPubsubSubscription)subscription), this.messageAcknowledger, (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withClientConfiguration(new ClientConfiguration())).withRegion(topicArn.getRegion())).build(), (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withClientConfiguration(new ClientConfiguration())).withRegion(queueArn.getRegion())).build(), PubSubUtils.getEnabledSupplier(this.dynamicConfig, subscription, this.discoveryStatus), this.registry);
            try {
                executorService.submit(worker);
                subscribers.add(worker);
                log.debug("Created worker {} for subscription: {}", (Object)worker.getWorkerName(), (Object)subscription.getName());
            }
            catch (RejectedExecutionException e) {
                log.error("Could not start {}", (Object)worker.getWorkerName(), (Object)e);
            }
        });
        this.pubsubSubscribers.putAll(subscribers);
    }
}

