/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.pubsub.aws;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiptHandleIsInvalidException;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.pubsub.aws.AmazonSubscriptionInformation;
import com.netflix.spinnaker.kork.pubsub.aws.api.AmazonMessageAcknowledger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAmazonMessageAcknowledger
implements AmazonMessageAcknowledger {
    private static final Logger log = LoggerFactory.getLogger(DefaultAmazonMessageAcknowledger.class);
    private Registry registry;

    public DefaultAmazonMessageAcknowledger(Registry registry) {
        this.registry = registry;
    }

    public void ack(AmazonSubscriptionInformation subscription, Message message) {
        try {
            subscription.amazonSQS.deleteMessage(subscription.queueUrl, message.getReceiptHandle());
            this.registry.counter(this.getSuccessCounter(subscription)).increment();
        }
        catch (ReceiptHandleIsInvalidException e) {
            log.warn("Error deleting message: {}, subscription: {}", new Object[]{message.getMessageId(), subscription, e});
            this.registry.counter(this.getErrorCounter(subscription, (Exception)((Object)e))).increment();
        }
    }

    public void nack(AmazonSubscriptionInformation subscription, Message message) {
        this.registry.counter(this.getNackCounter(subscription)).increment();
    }

    private Id getSuccessCounter(AmazonSubscriptionInformation subscription) {
        return this.registry.createId("pubsub.amazon.acked", new String[]{"subscription", subscription.properties.getName()});
    }

    private Id getErrorCounter(AmazonSubscriptionInformation subscription, Exception e) {
        return this.registry.createId("pubsub.amazon.ackFailed", new String[]{"subscription", subscription.properties.getName(), "exceptionClass", e.getClass().getSimpleName()});
    }

    private Id getNackCounter(AmazonSubscriptionInformation subscription) {
        return this.registry.createId("pubsub.amazon.nacked", new String[]{"subscription", subscription.properties.getName()});
    }
}

