/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.pubsub.aws;

import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.SNSActions;
import com.amazonaws.auth.policy.actions.SQSActions;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.netflix.spinnaker.kork.aws.ARN;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusListener;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.pubsub.aws.config.AmazonPubsubProperties;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubUtils {
    private static final Logger log = LoggerFactory.getLogger(PubSubUtils.class);
    private static final RetrySupport retrySupport = new RetrySupport();
    private static final int MAX_RETRIES = 5;
    private static final Duration RETRY_BACKOFF = Duration.ofSeconds(1L);
    private static final boolean EXPONENTIAL = true;

    private static String getQueueUrl(AmazonSQS amazonSQS, ARN queueARN) {
        String queueUrl;
        try {
            queueUrl = amazonSQS.getQueueUrl(queueARN.getName()).getQueueUrl();
            log.debug("Reusing existing queue {}", (Object)queueUrl);
        }
        catch (QueueDoesNotExistException e) {
            queueUrl = amazonSQS.createQueue(queueARN.getName()).getQueueUrl();
            log.debug("Created queue {}", (Object)queueUrl);
        }
        return queueUrl;
    }

    public static String ensureQueueExists(AmazonSQS amazonSQS, ARN queueARN, ARN topicARN, int sqsMessageRetentionPeriodSeconds) {
        String queueUrl = (String)retrySupport.retry(() -> PubSubUtils.getQueueUrl(amazonSQS, queueARN), 5, RETRY_BACKOFF, true);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("Policy", PubSubUtils.buildSQSPolicy(queueARN, topicARN).toJson());
        attributes.put("MessageRetentionPeriod", Integer.toString(sqsMessageRetentionPeriodSeconds));
        amazonSQS.setQueueAttributes(queueUrl, attributes);
        return queueUrl;
    }

    public static String subscribeToTopic(AmazonSNS amazonSNS, ARN topicARN, ARN queueARN) {
        return (String)retrySupport.retry(() -> amazonSNS.subscribe(topicARN.getArn(), "sqs", queueARN.getArn()).getSubscriptionArn(), 5, RETRY_BACKOFF, true);
    }

    public static Policy buildSQSPolicy(ARN queue, ARN topic) {
        Statement snsStatement = new Statement(Statement.Effect.Allow).withActions(new Action[]{SQSActions.SendMessage});
        snsStatement.setPrincipals(new Principal[]{Principal.All});
        snsStatement.setResources(Collections.singletonList(new Resource(queue.getArn())));
        snsStatement.setConditions(Collections.singletonList(new Condition().withType("ArnEquals").withConditionKey("aws:SourceArn").withValues(new String[]{topic.getArn()})));
        return new Policy("allow-sns-send", Collections.singletonList(snsStatement));
    }

    public static String ensureTopicExists(AmazonSNS amazonSNS, ARN topicARN, AmazonPubsubProperties.AmazonPubsubSubscription subscription) {
        String createdTopicARN = (String)retrySupport.retry(() -> amazonSNS.createTopic(topicARN.getName()).getTopicArn(), 5, RETRY_BACKOFF, true);
        log.debug(createdTopicARN.equals(topicARN.getArn()) ? "Reusing existing topic {}" : "Created topic {}", (Object)createdTopicARN);
        if (!subscription.getAccountIds().isEmpty()) {
            amazonSNS.setTopicAttributes(new SetTopicAttributesRequest().withTopicArn(createdTopicARN).withAttributeName("Policy").withAttributeValue(PubSubUtils.buildSNSPolicy(new ARN(createdTopicARN), subscription.getAccountIds()).toJson()));
        }
        return createdTopicARN;
    }

    public static Supplier<Boolean> getEnabledSupplier(DynamicConfigService dynamicConfig, AmazonPubsubProperties.AmazonPubsubSubscription subscription, DiscoveryStatusListener discoveryStatus) {
        return () -> dynamicConfig.isEnabled("pubsub", false) && dynamicConfig.isEnabled("pubsub.amazon", false) && dynamicConfig.isEnabled("pubsub.amazon." + subscription.getName(), false) && discoveryStatus.isEnabled();
    }

    public static Policy buildSNSPolicy(ARN topicARN, List<String> accountIds) {
        Statement statement = new Statement(Statement.Effect.Allow).withActions(new Action[]{SNSActions.Publish});
        statement.setPrincipals((Collection)accountIds.stream().map(Principal::new).collect(Collectors.toList()));
        statement.setResources(Collections.singletonList(new Resource(topicARN.getArn())));
        return new Policy("allow-remote-account-send", Collections.singletonList(statement));
    }
}

